/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.servicecomb.toolkit.common.CompareAlgorithm;
import org.apache.servicecomb.toolkit.common.ComparisionType;
import org.apache.servicecomb.toolkit.common.Comparison;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyersAlgorithm
implements CompareAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyersAlgorithm.class);

    @Override
    public List<Comparison> compare(String source, String dest) {
        if (source == null || dest == null) {
            LOGGER.error("Source is {} and dest is {}", (Object)source, (Object)dest);
            throw new RuntimeException("Source and dest must not be null");
        }
        EditList diffList = new EditList();
        diffList.addAll((Collection)MyersDiff.INSTANCE.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)new RawText(source.getBytes()), (Sequence)new RawText(dest.getBytes())));
        ArrayList<Comparison> comparisonList = new ArrayList<Comparison>();
        diffList.stream().forEachOrdered(edit -> {
            ComparisionType comparisionType;
            switch (edit.getType()) {
                case INSERT: {
                    comparisionType = ComparisionType.INSERT;
                    break;
                }
                case DELETE: {
                    comparisionType = ComparisionType.DELETE;
                    break;
                }
                case REPLACE: {
                    comparisionType = ComparisionType.REPLACE;
                    break;
                }
                default: {
                    comparisionType = ComparisionType.EQUAL;
                }
            }
            comparisonList.add(new Comparison(comparisionType, edit.getBeginA(), edit.getEndA(), edit.getBeginB(), edit.getEndB()));
        });
        return comparisonList;
    }
}

