/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.validation.api.MediaTypeValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.EncodingValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.MediaTypeValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.SchemaValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.mediatype.MediaTypeEncodingValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.mediatype.MediaTypeSchemaValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultMediaTypeValidatorFactory
implements MediaTypeValidatorFactory {
    private final SchemaValidatorFactory schemaValidatorFactory;
    private final EncodingValidatorFactory encodingValidatorFactory;

    public DefaultMediaTypeValidatorFactory(SchemaValidatorFactory schemaValidatorFactory, EncodingValidatorFactory encodingValidatorFactory) {
        this.schemaValidatorFactory = schemaValidatorFactory;
        this.encodingValidatorFactory = encodingValidatorFactory;
    }

    public List<MediaTypeValidator> create(FactoryOptions options) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new MediaTypeSchemaValidator(this.schemaValidatorFactory.create(options)));
        validators.add(new MediaTypeEncodingValidator(this.encodingValidatorFactory.create(options)));
        return Collections.unmodifiableList(validators);
    }
}

