/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.foundation.common.http.HttpUtils;

public class PathProcessorCreator
implements ParamValueProcessorCreator {
    public static final String PARAMTYPE = "path";

    public PathProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = TypeFactory.defaultInstance().constructType(genericParamType);
        return new PathProcessor(parameter.getName(), targetType, ((PathParameter)parameter).getDefaultValue(), true);
    }

    public static class PathProcessor
    extends AbstractParamProcessor {
        public PathProcessor(String paramPath, JavaType targetType, Object defaultValue, boolean required) {
            super(paramPath, targetType, defaultValue, required);
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            Map pathVarMap = (Map)request.getAttribute("servicecomb-paths");
            if (pathVarMap == null) {
                return null;
            }
            String value = (String)pathVarMap.get(this.paramPath);
            if (value == null) {
                return null;
            }
            return this.convertValue(HttpUtils.uriDecodePath((String)value), this.targetType);
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
        }

        @Override
        public String getProcessorType() {
            return PathProcessorCreator.PARAMTYPE;
        }
    }
}

