/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.List;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;

public class EndpointMeter {
    public static final String ADDRESS = "address";
    public static final String STATISTIC = "statistic";
    public static final String CONNECT_COUNT = "connectCount";
    public static final String DISCONNECT_COUNT = "disconnectCount";
    public static final String CONNECTIONS = "connections";
    public static final String BYTES_READ = "bytesRead";
    public static final String BYTES_WRITTEN = "bytesWritten";
    protected Id id;
    private Id idConnect;
    private Id idDisconnect;
    private Id idConnections;
    private Id idBytesRead;
    private Id idBytesWritten;
    protected DefaultEndpointMetric metric;
    private long lastConnectCount;
    private long lastDisconnectCount;
    private long lastBytesRead;
    private long lastBytesWritten;

    public EndpointMeter(Id id, DefaultEndpointMetric metric) {
        this.id = id = id.withTag(ADDRESS, metric.getAddress().toString());
        this.idConnect = id.withTag(STATISTIC, CONNECT_COUNT);
        this.idDisconnect = id.withTag(STATISTIC, DISCONNECT_COUNT);
        this.idConnections = id.withTag(STATISTIC, CONNECTIONS);
        this.idBytesRead = id.withTag(STATISTIC, BYTES_READ);
        this.idBytesWritten = id.withTag(STATISTIC, BYTES_WRITTEN);
        this.metric = metric;
    }

    public DefaultEndpointMetric getMetric() {
        return this.metric;
    }

    protected Measurement newMeasurement(Id id, long timestamp, Number n) {
        return new Measurement(id, timestamp, n.doubleValue());
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow, double secondInterval) {
        long connectCount = this.metric.getConnectCount();
        long disconnectCount = this.metric.getDisconnectCount();
        long bytesRead = this.metric.getBytesRead();
        long bytesWritten = this.metric.getBytesWritten();
        measurements.add(this.newMeasurement(this.idConnect, msNow, connectCount - this.lastConnectCount));
        measurements.add(this.newMeasurement(this.idDisconnect, msNow, disconnectCount - this.lastDisconnectCount));
        measurements.add(this.newMeasurement(this.idConnections, msNow, connectCount - disconnectCount));
        measurements.add(this.newMeasurement(this.idBytesRead, msNow, (double)(bytesRead - this.lastBytesRead) / secondInterval));
        measurements.add(this.newMeasurement(this.idBytesWritten, msNow, (double)(bytesWritten - this.lastBytesWritten) / secondInterval));
        this.lastConnectCount = connectCount;
        this.lastDisconnectCount = disconnectCount;
        this.lastBytesRead = bytesRead;
        this.lastBytesWritten = bytesWritten;
    }
}

