/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.time.Clock;
import java.util.Objects;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.TimeUtils;
import org.apache.servicecomb.loadbalance.Configuration;

public class TryingIsolatedServerMarker {
    Clock clock;
    final long startTryingTimestamp;
    private final Invocation invocation;
    private final int maxSingleTestWindow;

    public TryingIsolatedServerMarker(Invocation invocation) {
        Objects.requireNonNull(invocation, "invocation should be non-null");
        this.invocation = invocation;
        this.clock = TimeUtils.getSystemDefaultZoneClock();
        this.startTryingTimestamp = this.clock.millis();
        this.maxSingleTestWindow = Configuration.INSTANCE.getMaxSingleTestWindow();
    }

    public boolean isOutdated() {
        return this.invocation.isFinished() || this.clock.millis() - this.startTryingTimestamp >= (long)this.maxSingleTestWindow;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }
}

