/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.protostuff.compiler.model.AbstractUserTypeContainer;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.Group;
import io.protostuff.compiler.model.GroupContainer;
import io.protostuff.compiler.model.Oneof;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Range;
import io.protostuff.compiler.model.UserType;
import io.protostuff.compiler.model.UserTypeContainer;
import java.util.ArrayList;
import java.util.List;

public class Message
extends AbstractUserTypeContainer
implements UserType,
UserTypeContainer,
FieldContainer,
GroupContainer {
    protected List<Field> fields = new ArrayList<Field>();
    protected List<Group> groups = new ArrayList<Group>();
    protected List<Oneof> oneofs = new ArrayList<Oneof>();
    protected Proto proto;
    protected String fullyQualifiedName;
    protected List<Range> extensionRanges = new ArrayList<Range>();
    protected List<Range> reservedFieldRanges = new ArrayList<Range>();
    protected List<String> reservedFieldNames = new ArrayList<String>();

    public Message(UserTypeContainer parent) {
        super(parent);
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.MESSAGE;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public void addField(Field field) {
        this.fields.add(field);
    }

    @Override
    public Field getField(String name) {
        for (Field field : this.getFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    @Override
    public Field getField(int tag) {
        for (Field field : this.getFields()) {
            if (tag != field.getTag()) continue;
            return field;
        }
        return null;
    }

    public List<Oneof> getOneofs() {
        return this.oneofs;
    }

    public void setOneofs(List<Oneof> oneofs) {
        this.oneofs = oneofs;
    }

    public void addOneof(Oneof oneof) {
        this.oneofs.add(oneof);
    }

    public Oneof getOneof(String name) {
        for (Oneof oneof : this.getOneofs()) {
            if (!name.equals(oneof.getName())) continue;
            return oneof;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("fullyQualifiedName", (Object)this.getFullyQualifiedName()).add("fields", this.fields).add("messages", (Object)this.messages).add("enums", (Object)this.enums).add("options", (Object)this.options).toString();
    }

    @Override
    public Proto getProto() {
        return this.proto;
    }

    @Override
    public void setProto(Proto proto) {
        this.proto = proto;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Override
    public String getCanonicalName() {
        String fqn = this.getFullyQualifiedName();
        if (fqn.startsWith(".")) {
            return fqn.substring(1);
        }
        return fqn;
    }

    @Override
    public boolean isNested() {
        return this.getParent().getDescriptorType() != DescriptorType.PROTO;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isMessage() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public String getNamespace() {
        Preconditions.checkNotNull((Object)this.fullyQualifiedName, (Object)"message is not initialized");
        return this.fullyQualifiedName + ".";
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @Override
    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public List<Range> getExtensionRanges() {
        return this.extensionRanges;
    }

    public void setExtensionRanges(List<Range> extensionRanges) {
        this.extensionRanges = extensionRanges;
    }

    public void addExtensionRange(Range range) {
        this.extensionRanges.add(range);
    }

    @Override
    public List<Range> getReservedFieldRanges() {
        return this.reservedFieldRanges;
    }

    public void setReservedFieldRanges(List<Range> reservedFieldRanges) {
        this.reservedFieldRanges = reservedFieldRanges;
    }

    @Override
    public void addReservedFieldRange(Range range) {
        this.reservedFieldRanges.add(range);
    }

    @Override
    public List<String> getReservedFieldNames() {
        return this.reservedFieldNames;
    }

    public void setReservedFieldNames(List<String> reservedFieldNames) {
        this.reservedFieldNames = reservedFieldNames;
    }

    @Override
    public void addReservedFieldName(String name) {
        this.reservedFieldNames.add(name);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    public boolean isMapEntry() {
        DynamicMessage.Value value = this.getOptions().get("map_entry");
        return value != null && value.isBooleanType() && value.getBoolean();
    }
}

