package org.apache.maven.plugin.coreit;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * Tries to load the resource maven-core-it.properties from the system-scoped plugin dependency.
 * 
 * @goal coreit
 * @phase validate
 * 
 * @author Benjamin Bentmann
 * @version $Id: FileMojo.java 698220 2008-09-23 16:18:19Z bentmann $
 */
public class CoreitMojo
    extends AbstractMojo
{

    /**
     * The path to the output file.
     * 
     * @parameter expression="${coreit.outputFile}" default-value="target/it.properties"
     */
    private File outputFile;

    /**
     * Runs this mojo.
     * 
     * @throws MojoExecutionException If the output file could not be created.
     */
    public void execute()
        throws MojoExecutionException
    {
        String resource = "maven-core-it.properties";

        Properties props = new Properties();

        getLog().info( "[MAVEN-CORE-IT-LOG] Loading resource: " + resource );

        InputStream in = getClass().getResourceAsStream( "/" + resource );

        try
        {
            if ( in != null )
            {
                props.load( in );
            }
            else
            {
                throw new IOException( "Resource not found" );
            }
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( "Properties could not be loaded", e );
        }

        getLog().info( "[MAVEN-CORE-IT-LOG] Creating output file: " + outputFile );

        try
        {
            outputFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream( outputFile );
            try
            {
                props.store( out, "MAVEN-CORE-IT" );
            }
            finally
            {
                out.close();
            }
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( "Output file could not be created: " + outputFile, e );
        }

        getLog().info( "[MAVEN-CORE-IT-LOG] Created output file: " + outputFile );
    }

}
