/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notifications.email;

import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailSession {
    protected final String server;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final String protocol;
    protected final Properties properties;
    private Session session = null;
    private Store store = null;

    public EmailSession(String server, int port, String username, String password, String protocol, Properties properties) throws MessagingException {
        this.server = server;
        this.port = port;
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.properties = properties;
        Session thisSession = Session.getDefaultInstance((Properties)properties, null);
        Store thisStore = thisSession.getStore(protocol);
        thisStore.connect(server, port, username, password);
        this.session = thisSession;
        this.store = thisStore;
    }

    public void checkConnection() throws MessagingException {
        if (this.store != null && this.store.getDefaultFolder() == null) {
            throw new MessagingException("Error checking the connection: No default folder.");
        }
    }

    public void send(List<String> to, String from, String subject, String body) throws MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(from));
        for (String toValue : to) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toValue));
        }
        message.setSubject(subject);
        message.setText(body);
        Transport.send((Message)message);
    }

    public void close() throws MessagingException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.session = null;
    }
}

