/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.common;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.manifoldcf.core.common.XThreadInputStream;

public class XThreadOutputStream
extends OutputStream {
    protected final XThreadInputStream inputStream;
    byte[] byteBuffer = new byte[1];

    public XThreadOutputStream(XThreadInputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        try {
            this.inputStream.stuffQueue(buffer, 0, buffer.length);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.byteBuffer[0] = (byte)c;
        try {
            this.inputStream.stuffQueue(this.byteBuffer, 0, 1);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    @Override
    public void write(byte[] buffer, int pos, int amt) throws IOException {
        try {
            this.inputStream.stuffQueue(buffer, pos, amt);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.doneStuffingQueue();
        super.close();
    }
}

