/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.common;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ConnectTimeoutException;

public class InterruptibleSocketFactory
extends SSLSocketFactory {
    protected final SSLSocketFactory wrappedFactory;
    protected final long connectTimeoutMilliseconds;

    public InterruptibleSocketFactory(SSLSocketFactory wrappedFactory, long connectTimeoutMilliseconds) {
        this.wrappedFactory = wrappedFactory;
        this.connectTimeoutMilliseconds = connectTimeoutMilliseconds;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.wrappedFactory.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.fireOffThread(InetAddress.getByName(host), port, null, -1);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.fireOffThread(host, port, null, -1);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.fireOffThread(InetAddress.getByName(host), port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.fireOffThread(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.wrappedFactory.createSocket(s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.wrappedFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.wrappedFactory.getSupportedCipherSuites();
    }

    protected Socket fireOffThread(InetAddress address, int port, InetAddress localHost, int localPort) throws IOException {
        SocketCreateThread thread = new SocketCreateThread(this.wrappedFactory, address, port, localHost, localPort);
        thread.start();
        try {
            thread.join(this.connectTimeoutMilliseconds);
            if (thread.isAlive()) {
                thread.interrupt();
                throw new ConnectTimeoutException("Secure connection timed out");
            }
            Throwable t = thread.getException();
            if (t != null) {
                if (t instanceof SocketTimeoutException) {
                    throw (SocketTimeoutException)t;
                }
                if (t instanceof ConnectTimeoutException) {
                    throw (ConnectTimeoutException)t;
                }
                if (t instanceof InterruptedIOException) {
                    throw (InterruptedIOException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new Error("Received an unexpected exception: " + t.getMessage(), t);
            }
            return thread.getResult();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted: " + e.getMessage());
        }
    }

    protected static class SocketCreateThread
    extends Thread {
        protected SSLSocketFactory socketFactory;
        protected InetAddress host;
        protected int port;
        protected InetAddress clientHost;
        protected int clientPort;
        protected Socket rval = null;
        protected Throwable throwable = null;

        public SocketCreateThread(SSLSocketFactory socketFactory, InetAddress host, int port, InetAddress clientHost, int clientPort) {
            this.socketFactory = socketFactory;
            this.host = host;
            this.port = port;
            this.clientHost = clientHost;
            this.clientPort = clientPort;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.rval = this.clientHost == null ? this.socketFactory.createSocket(this.host, this.port) : this.socketFactory.createSocket(this.host, this.port, this.clientHost, this.clientPort);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        public Throwable getException() {
            return this.throwable;
        }

        public Socket getResult() {
            return this.rval;
        }
    }
}

