/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.IPipelineConnections;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.DeleteQueuedDocument;
import org.apache.manifoldcf.crawler.system.DocDeleteResetManager;
import org.apache.manifoldcf.crawler.system.DocumentDeleteQueue;
import org.apache.manifoldcf.crawler.system.DocumentDeleteSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.PipelineConnections;
import org.apache.manifoldcf.crawler.system.PipelineSpecificationBasic;

public class DocumentDeleteThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: DocumentDeleteThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final String id;
    protected final DocumentDeleteQueue documentDeleteQueue;
    protected final DocDeleteResetManager resetManager;
    protected final String processID;

    public DocumentDeleteThread(String id, DocumentDeleteQueue documentDeleteQueue, DocDeleteResetManager resetManager, String processID) throws ManifoldCFException {
        this.id = id;
        this.documentDeleteQueue = documentDeleteQueue;
        this.resetManager = resetManager;
        this.processID = processID;
        this.setName("Document delete thread '" + id + "'");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IIncrementalIngester ingester = IncrementalIngesterFactory.make((IThreadContext)threadContext);
            IRepositoryConnectionManager connMgr = RepositoryConnectionManagerFactory.make(threadContext);
            ITransformationConnectionManager transformationConnectionManager = TransformationConnectionManagerFactory.make((IThreadContext)threadContext);
            IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
            while (true) {
                try {
                    block15: while (true) {
                        this.resetManager.waitForReset(threadContext);
                        DocumentDeleteSet dds = this.documentDeleteQueue.getDocuments();
                        if (dds == null) continue;
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)("Document delete thread received " + Integer.toString(dds.getCount()) + " documents to delete for job " + dds.getJobDescription().getID().toString()));
                        }
                        IJobDescription job = dds.getJobDescription();
                        String connectionName = job.getConnectionName();
                        PipelineConnections pipelineConnections = new PipelineConnections(new PipelineSpecificationBasic(job), transformationConnectionManager, outputConnectionManager);
                        try {
                            int j;
                            boolean[] deleteFromQueue = new boolean[dds.getCount()];
                            String[] docClassesToRemove = new String[dds.getCount()];
                            String[] hashedDocsToRemove = new String[dds.getCount()];
                            DeleteQueuedDocument[] docsToDelete = new DeleteQueuedDocument[dds.getCount()];
                            for (int j2 = 0; j2 < dds.getCount(); ++j2) {
                                DeleteQueuedDocument dqd = dds.getDocument(j2);
                                DocumentDescription ddd = dqd.getDocumentDescription();
                                docClassesToRemove[j2] = connectionName;
                                hashedDocsToRemove[j2] = ddd.getDocumentIdentifierHash();
                                docsToDelete[j2] = dqd;
                                deleteFromQueue[j2] = false;
                            }
                            OutputRemoveActivity logger = new OutputRemoveActivity(connectionName, connMgr);
                            try {
                                ingester.documentDeleteMultiple((IPipelineConnections)pipelineConnections, docClassesToRemove, hashedDocsToRemove, (IOutputRemoveActivity)logger);
                                for (int j3 = 0; j3 < dds.getCount(); ++j3) {
                                    deleteFromQueue[j3] = true;
                                }
                            }
                            catch (ServiceInterruption e) {
                                for (int j4 = 0; j4 < dds.getCount(); ++j4) {
                                    DeleteQueuedDocument cqd = docsToDelete[j4];
                                    DocumentDescription dd = cqd.getDocumentDescription();
                                    jobManager.resetDeletingDocument(dd, e.getRetryTime());
                                    cqd.setProcessed();
                                }
                            }
                            int recordCount = 0;
                            for (int j5 = 0; j5 < dds.getCount(); ++j5) {
                                if (!deleteFromQueue[j5]) continue;
                                ++recordCount;
                            }
                            DocumentDescription[] deleteDescriptions = new DocumentDescription[recordCount];
                            recordCount = 0;
                            for (j = 0; j < dds.getCount(); ++j) {
                                if (!deleteFromQueue[j]) continue;
                                deleteDescriptions[recordCount++] = docsToDelete[j].getDocumentDescription();
                            }
                            jobManager.deleteIngestedDocumentIdentifiers(deleteDescriptions);
                            j = 0;
                            while (true) {
                                if (j >= dds.getCount()) continue block15;
                                if (deleteFromQueue[j]) {
                                    docsToDelete[j].wasProcessed();
                                }
                                ++j;
                            }
                        }
                        finally {
                            for (int j = 0; j < dds.getCount(); ++j) {
                                DeleteQueuedDocument dqd = dds.getDocument(j);
                                if (dqd.wasProcessed()) continue;
                                DocumentDescription ddd = dqd.getDocumentDescription();
                                jobManager.resetDeletingDocument(ddd, 0L);
                                dqd.setProcessed();
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)("Document delete thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("DocumentDeleteThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }

    protected static class OutputRemoveActivity
    implements IOutputRemoveActivity {
        protected final IRepositoryConnectionManager connMgr;
        protected final String connectionName;

        public OutputRemoveActivity(String connectionName, IRepositoryConnectionManager connMgr) {
            this.connectionName = connectionName;
            this.connMgr = connMgr;
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connectionName, startTime, activityType, dataSize, entityURI, resultCode, resultDescription, null);
        }
    }
}

