/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.agents.interfaces.OutputSpecification;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.jobs.ScheduleList;

public class JobDescription
implements IJobDescription {
    public static final String _rcsid = "@(#)$Id: JobDescription.java 988245 2010-08-23 18:39:35Z kwright $";
    protected boolean isNew = true;
    protected Long id = null;
    protected String description = null;
    protected String connectionName = null;
    protected final List<PipelineStage> pipelineStages = new ArrayList<PipelineStage>();
    protected final List<Notification> notifications = new ArrayList<Notification>();
    protected int type = 0;
    protected int startMethod = 0;
    protected int priority = 5;
    protected ScheduleList scheduleList = new ScheduleList();
    protected Float rate = null;
    protected Long interval = new Long(86400000L);
    protected Long maxInterval = null;
    protected Long expiration = null;
    protected Long reseedInterval = new Long(3600000L);
    protected DocumentSpecification documentSpecification = new DocumentSpecification();
    protected HashMap hopCountFilters = new HashMap();
    protected int hopcountMode = 0;
    protected Map<String, Set<String>> forcedMetadata = new HashMap<String, Set<String>>();
    protected boolean readOnly = false;

    public JobDescription duplicate(boolean readOnly) {
        if (readOnly && this.readOnly) {
            return this;
        }
        JobDescription rval = new JobDescription();
        rval.id = this.id;
        rval.isNew = this.isNew;
        rval.connectionName = this.connectionName;
        rval.documentSpecification = this.documentSpecification.duplicate(readOnly);
        for (PipelineStage pipelineStage : this.pipelineStages) {
            rval.pipelineStages.add(new PipelineStage(pipelineStage.getPrerequisiteStage(), pipelineStage.getIsOutput(), pipelineStage.getConnectionName(), pipelineStage.getDescription(), (Specification)((OutputSpecification)pipelineStage.getSpecification()).duplicate(readOnly)));
        }
        for (Notification notification : this.notifications) {
            rval.notifications.add(new Notification(notification.getConnectionName(), notification.getDescription(), notification.getSpecification().duplicate(readOnly)));
        }
        rval.description = this.description;
        rval.type = this.type;
        rval.scheduleList = this.scheduleList.duplicate();
        rval.interval = this.interval;
        rval.maxInterval = this.maxInterval;
        rval.expiration = this.expiration;
        rval.reseedInterval = this.reseedInterval;
        rval.rate = this.rate;
        rval.priority = this.priority;
        rval.startMethod = this.startMethod;
        rval.hopcountMode = this.hopcountMode;
        for (String linkType : this.hopCountFilters.keySet()) {
            Long maxHops = (Long)this.hopCountFilters.get(linkType);
            rval.hopCountFilters.put(linkType, maxHops);
        }
        for (String forcedParamName : this.forcedMetadata.keySet()) {
            Set<String> values = this.forcedMetadata.get(forcedParamName);
            for (String value : values) {
                rval.addForcedMetadataValue(forcedParamName, value);
            }
        }
        rval.readOnly = readOnly;
        return rval;
    }

    public void makeReadOnly() {
        if (this.readOnly) {
            return;
        }
        this.readOnly = true;
        for (PipelineStage pipelineStage : this.pipelineStages) {
            pipelineStage.getSpecification().makeReadOnly();
        }
        for (Notification notification : this.notifications) {
            notification.getSpecification().makeReadOnly();
        }
        this.documentSpecification.makeReadOnly();
    }

    public void setIsNew(boolean isNew) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.isNew = isNew;
    }

    @Override
    public boolean getIsNew() {
        return this.isNew;
    }

    public void setID(Long id) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.id = id;
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public void setDescription(String description) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setConnectionName(String connectionName) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.connectionName = connectionName;
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public void clearPipeline() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.pipelineStages.clear();
    }

    @Override
    public Specification addPipelineStage(int prerequisiteStage, boolean isOutput, String pipelineStageConnectionName, String pipelineStageDescription) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        PipelineStage ps = new PipelineStage(prerequisiteStage, isOutput, pipelineStageConnectionName, pipelineStageDescription);
        this.pipelineStages.add(ps);
        return ps.getSpecification();
    }

    @Override
    public int countPipelineStages() {
        return this.pipelineStages.size();
    }

    @Override
    public Specification insertPipelineStage(int index, boolean isOutput, String pipelineStageConnectionName, String pipelineStageDescription) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        PipelineStage currentStage = this.pipelineStages.get(index);
        PipelineStage ps = new PipelineStage(currentStage.getPrerequisiteStage(), isOutput, pipelineStageConnectionName, pipelineStageDescription);
        this.pipelineStages.add(index, ps);
        currentStage.adjustReplacedStage(index, isOutput);
        for (int stage = index + 2; stage < this.pipelineStages.size(); ++stage) {
            this.pipelineStages.get(stage).adjustForInsert(index);
        }
        return ps.getSpecification();
    }

    @Override
    public int getPipelineStagePrerequisite(int index) {
        return this.pipelineStages.get(index).getPrerequisiteStage();
    }

    @Override
    public boolean getPipelineStageIsOutputConnection(int index) {
        return this.pipelineStages.get(index).getIsOutput();
    }

    @Override
    public String getPipelineStageConnectionName(int index) {
        return this.pipelineStages.get(index).getConnectionName();
    }

    @Override
    public String getPipelineStageDescription(int index) {
        return this.pipelineStages.get(index).getDescription();
    }

    @Override
    public Specification getPipelineStageSpecification(int index) {
        return this.pipelineStages.get(index).getSpecification();
    }

    @Override
    public void deletePipelineStage(int index) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        PipelineStage ps = this.pipelineStages.remove(index);
        for (int stage = index; stage < this.pipelineStages.size(); ++stage) {
            this.pipelineStages.get(stage).adjustForDelete(index, ps.getPrerequisiteStage());
        }
    }

    @Override
    public void clearNotifications() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.notifications.clear();
    }

    @Override
    public Specification addNotification(String notificationConnectionName, String notificationDescription) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        Notification ps = new Notification(notificationConnectionName, notificationDescription);
        this.notifications.add(ps);
        return ps.getSpecification();
    }

    @Override
    public int countNotifications() {
        return this.notifications.size();
    }

    @Override
    public String getNotificationConnectionName(int index) {
        return this.notifications.get(index).getConnectionName();
    }

    @Override
    public String getNotificationDescription(int index) {
        return this.notifications.get(index).getDescription();
    }

    @Override
    public Specification getNotificationSpecification(int index) {
        return this.notifications.get(index).getSpecification();
    }

    @Override
    public void deleteNotification(int index) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.notifications.remove(index);
    }

    @Override
    public Specification insertNotification(int index, String notificationConnectionName, String notificationDescription) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        Notification ps = new Notification(notificationConnectionName, notificationDescription);
        this.notifications.add(index, ps);
        return ps.getSpecification();
    }

    @Override
    public void setType(int type) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setStartMethod(int startMethod) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.startMethod = startMethod;
    }

    @Override
    public int getStartMethod() {
        return this.startMethod;
    }

    @Override
    public void clearScheduleRecords() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.scheduleList.clear();
    }

    @Override
    public void addScheduleRecord(ScheduleRecord record) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.scheduleList.addRecord(record);
    }

    @Override
    public int getScheduleRecordCount() {
        return this.scheduleList.getRecordCount();
    }

    @Override
    public ScheduleRecord getScheduleRecord(int index) {
        return this.scheduleList.getRecord(index);
    }

    @Override
    public void deleteScheduleRecord(int index) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.scheduleList.deleteRecord(index);
    }

    @Override
    public void setInterval(Long interval) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.interval = interval;
    }

    @Override
    public Long getInterval() {
        return this.interval;
    }

    @Override
    public void setMaxInterval(Long interval) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.maxInterval = interval;
    }

    @Override
    public Long getMaxInterval() {
        return this.maxInterval;
    }

    @Override
    public void setExpiration(Long time) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.expiration = time;
    }

    @Override
    public Long getExpiration() {
        return this.expiration;
    }

    @Override
    public void setReseedInterval(Long interval) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.reseedInterval = interval;
    }

    @Override
    public Long getReseedInterval() {
        return this.reseedInterval;
    }

    @Override
    public DocumentSpecification getSpecification() {
        return this.documentSpecification;
    }

    @Override
    public void setPriority(int priority) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Map getHopCountFilters() {
        return (Map)this.hopCountFilters.clone();
    }

    @Override
    public void clearHopCountFilters() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.hopCountFilters.clear();
    }

    @Override
    public void addHopCountFilter(String linkType, Long maxHops) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.hopCountFilters.put(linkType, maxHops);
    }

    @Override
    public int getHopcountMode() {
        return this.hopcountMode;
    }

    @Override
    public void setHopcountMode(int mode) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.hopcountMode = mode;
    }

    @Override
    public Map<String, Set<String>> getForcedMetadata() {
        return this.forcedMetadata;
    }

    @Override
    public void clearForcedMetadata() {
        this.forcedMetadata.clear();
    }

    @Override
    public void addForcedMetadataValue(String name, String value) {
        Set<String> rval = this.forcedMetadata.get(name);
        if (rval == null) {
            rval = new HashSet<String>();
            this.forcedMetadata.put(name, rval);
        }
        rval.add(value);
    }

    protected static class PipelineStage {
        protected int prerequisiteStage;
        protected final boolean isOutput;
        protected final String connectionName;
        protected final String description;
        protected final Specification specification;

        public PipelineStage(int prerequisiteStage, boolean isOutput, String connectionName, String description) {
            this.prerequisiteStage = prerequisiteStage;
            this.isOutput = isOutput;
            this.connectionName = connectionName;
            this.description = description;
            this.specification = new OutputSpecification();
        }

        public PipelineStage(int prerequisiteStage, boolean isOutput, String connectionName, String description, Specification spec) {
            this.prerequisiteStage = prerequisiteStage;
            this.isOutput = isOutput;
            this.connectionName = connectionName;
            this.description = description;
            this.specification = spec;
        }

        public void adjustReplacedStage(int index, boolean isOutput) {
            if (!isOutput) {
                this.prerequisiteStage = index;
            } else {
                this.adjustForInsert(index);
            }
        }

        public void adjustForInsert(int index) {
            if (this.prerequisiteStage >= index) {
                ++this.prerequisiteStage;
            }
        }

        public void adjustForDelete(int index, int prerequisite) {
            if (this.prerequisiteStage > index) {
                --this.prerequisiteStage;
            } else if (this.prerequisiteStage == index) {
                this.prerequisiteStage = prerequisite;
            }
        }

        public Specification getSpecification() {
            return this.specification;
        }

        public int getPrerequisiteStage() {
            return this.prerequisiteStage;
        }

        public boolean getIsOutput() {
            return this.isOutput;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    protected static class Notification {
        protected final String connectionName;
        protected final String description;
        protected final Specification specification;

        public Notification(String connectionName, String description) {
            this.connectionName = connectionName;
            this.description = description;
            this.specification = new Specification();
        }

        public Notification(String connectionName, String description, Specification spec) {
            this.connectionName = connectionName;
            this.description = description;
            this.specification = spec;
        }

        public Specification getSpecification() {
            return this.specification;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

