/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.confluence.model;

import java.io.InputStream;
import java.util.Map;
import org.apache.manifoldcf.crawler.connectors.confluence.model.Page;
import org.apache.manifoldcf.crawler.connectors.confluence.model.builder.ConfluenceResourceBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class Attachment
extends Page {
    protected static final String KEY_DOWNLOAD = "download";
    protected static final String KEY_EXTENSIONS = "extensions";
    protected String downloadUrl;
    protected InputStream contentStream;

    public static ConfluenceResourceBuilder<Attachment> builder() {
        return new AttachmentBuilder();
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public boolean hasContent() {
        return this.length > 0L && this.hasContentStream() != false || this.downloadUrl != null && !this.downloadUrl.isEmpty();
    }

    public Boolean hasContentStream() {
        return this.contentStream != null;
    }

    @Override
    public InputStream getContentStream() {
        if (this.hasContentStream().booleanValue()) {
            return this.contentStream;
        }
        return super.getContentStream();
    }

    @Override
    protected void refineMetadata(Map<String, Object> metadata) {
        super.refineMetadata(metadata);
        metadata.put("downloadUrl", this.getBaseUrl() + this.getUrlContext() + this.downloadUrl);
    }

    public static class AttachmentBuilder
    implements ConfluenceResourceBuilder<Attachment> {
        @Override
        public Attachment fromJson(JSONObject jsonPage) {
            return this.fromJson(jsonPage, new Attachment());
        }

        @Override
        public Attachment fromJson(JSONObject jsonPage, Attachment attachment) {
            Page.builder().fromJson(jsonPage, attachment);
            try {
                JSONObject extensions;
                JSONObject links = (JSONObject)jsonPage.get("_links");
                if (links != null) {
                    attachment.downloadUrl = links.optString(Attachment.KEY_DOWNLOAD, "");
                }
                if ((extensions = (JSONObject)jsonPage.get(Attachment.KEY_EXTENSIONS)) != null) {
                    attachment.mediaType = extensions.optString("mediaType", "");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return attachment;
        }

        @Override
        public Class<Attachment> getType() {
            return Attachment.class;
        }
    }
}

