/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.websockets;

import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.websockets.MessageEventCallback;
import org.apache.knox.gateway.websockets.ProxyInboundClient;
import org.apache.knox.gateway.websockets.WebsocketLogMessages;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;

public class ProxyWebSocketAdapter
extends WebSocketAdapter {
    protected static final WebsocketLogMessages LOG = (WebsocketLogMessages)MessagesFactory.get(WebsocketLogMessages.class);
    private final URI backend;
    private org.eclipse.jetty.websocket.api.Session frontendSession;
    private Session backendSession;
    private WebSocketContainer container;
    protected ExecutorService pool;
    private List<String> messageBuffer = new ArrayList<String>();
    private Lock remoteLock = new ReentrantLock();
    protected final GatewayConfig config;
    private ClientEndpointConfig clientConfig;

    public ProxyWebSocketAdapter(URI backend, ExecutorService pool, GatewayConfig config) {
        this(backend, pool, null, config);
    }

    public ProxyWebSocketAdapter(URI backend, ExecutorService pool, ClientEndpointConfig clientConfig, GatewayConfig config) {
        this.backend = backend;
        this.pool = pool;
        this.clientConfig = clientConfig;
        this.config = config;
    }

    public void onWebSocketConnect(org.eclipse.jetty.websocket.api.Session frontEndSession) {
        this.container = ContainerProvider.getWebSocketContainer();
        this.container.setDefaultMaxTextMessageBufferSize(frontEndSession.getPolicy().getMaxTextMessageBufferSize());
        this.container.setDefaultMaxBinaryMessageBufferSize(frontEndSession.getPolicy().getMaxBinaryMessageBufferSize());
        this.container.setAsyncSendTimeout(frontEndSession.getPolicy().getAsyncWriteTimeout());
        this.container.setDefaultMaxSessionIdleTimeout(frontEndSession.getPolicy().getIdleTimeout());
        KeyStore ks = null;
        if (this.clientConfig != null) {
            ks = (KeyStore)this.clientConfig.getUserProperties().get("org.apache.knox.gateway.websockets.truststore");
        }
        if (this.container instanceof ClientContainer && ((ClientContainer)this.container).getClient() != null && ((ClientContainer)this.container).getClient().getSslContextFactory() != null) {
            ((ClientContainer)this.container).getClient().getHttpClient().getSslContextFactory().setTrustStore(ks);
            LOG.logMessage("Truststore for websocket setup");
        }
        ProxyInboundClient backendSocket = new ProxyInboundClient(this.getMessageCallback());
        try {
            this.backendSession = this.container.connectToServer((Endpoint)backendSocket, this.clientConfig, this.backend);
            LOG.onConnectionOpen(this.backend.toString());
        }
        catch (DeploymentException e) {
            LOG.connectionFailed((Exception)((Object)e));
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOG.connectionFailed(e);
            throw new RuntimeIOException((Throwable)e);
        }
        this.remoteLock.lock();
        super.onWebSocketConnect(frontEndSession);
        this.frontendSession = frontEndSession;
        RemoteEndpoint remote = frontEndSession.getRemote();
        try {
            if (!this.messageBuffer.isEmpty()) {
                this.flushBufferedMessages(remote);
                if (remote.getBatchMode() == BatchMode.ON) {
                    remote.flush();
                }
            } else {
                LOG.debugLog("Message buffer is empty");
            }
        }
        catch (IOException e) {
            LOG.connectionFailed(e);
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            this.remoteLock.unlock();
        }
    }

    public void onWebSocketBinary(byte[] payload, int offset, int length) {
        if (this.isNotConnected()) {
            return;
        }
        throw new UnsupportedOperationException("Websocket support for binary messages is not supported at this time.");
    }

    public void onWebSocketText(String message) {
        if (this.isNotConnected()) {
            return;
        }
        LOG.logMessage("[From Frontend --->]" + message);
        try {
            this.backendSession.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            LOG.connectionFailed(e);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        this.cleanup();
        LOG.onConnectionClose(this.backend.toString());
    }

    public void onWebSocketError(Throwable t) {
        this.cleanupOnError(t);
    }

    private void cleanupOnError(Throwable t) {
        LOG.onError(t.toString());
        if (t.toString().contains("exceeds maximum size")) {
            if (this.frontendSession != null && !this.frontendSession.isOpen()) {
                this.frontendSession.close(1009, t.getMessage());
            }
        } else {
            if (this.frontendSession != null && !this.frontendSession.isOpen()) {
                this.frontendSession.close(1011, t.getMessage());
            }
            this.cleanup();
        }
    }

    private MessageEventCallback getMessageCallback() {
        return new MessageEventCallback(){

            @Override
            public void doCallback(String message) {
            }

            @Override
            public void onConnectionOpen(Object session) {
            }

            @Override
            public void onConnectionClose(CloseReason reason) {
                try {
                    ProxyWebSocketAdapter.this.frontendSession.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
                }
                finally {
                    ProxyWebSocketAdapter.this.cleanup();
                }
            }

            @Override
            public void onError(Throwable cause) {
                ProxyWebSocketAdapter.this.cleanupOnError(cause);
            }

            @Override
            public void onMessageText(String message, Object session) {
                LOG.logMessage("[From Backend <---]" + message);
                ProxyWebSocketAdapter.this.remoteLock.lock();
                RemoteEndpoint remote = ProxyWebSocketAdapter.this.getRemote();
                try {
                    if (remote == null) {
                        LOG.debugLog("Remote endpoint is null");
                        if (ProxyWebSocketAdapter.this.messageBuffer.size() >= ProxyWebSocketAdapter.this.config.getWebsocketMaxWaitBufferCount()) {
                            throw new RuntimeIOException("Remote is null and message buffer is full. Cannot buffer anymore ");
                        }
                        LOG.debugLog("Buffering message: " + message);
                        ProxyWebSocketAdapter.this.messageBuffer.add(message);
                        return;
                    }
                    ProxyWebSocketAdapter.this.flushBufferedMessages(remote);
                    LOG.debugLog("Sending current message [From Backend <---]: " + message);
                    remote.sendString(message);
                    if (remote.getBatchMode() == BatchMode.ON) {
                        remote.flush();
                    }
                }
                catch (IOException e) {
                    LOG.connectionFailed(e);
                    throw new RuntimeIOException((Throwable)e);
                }
                finally {
                    ProxyWebSocketAdapter.this.remoteLock.unlock();
                }
            }

            @Override
            public void onMessageBinary(byte[] message, boolean last, Object session) {
                throw new UnsupportedOperationException("Websocket support for binary messages is not supported at this time.");
            }

            @Override
            public void onMessagePong(PongMessage message, Object session) {
                LOG.logMessage("[From Backend <---]: PING");
                ProxyWebSocketAdapter.this.remoteLock.lock();
                RemoteEndpoint remote = ProxyWebSocketAdapter.this.getRemote();
                try {
                    if (remote == null) {
                        LOG.debugLog("Remote endpoint is null");
                        return;
                    }
                    ProxyWebSocketAdapter.this.flushBufferedMessages(remote);
                    LOG.logMessage("Sending current PING [From Backend <---]: ");
                    remote.sendPing(message.getApplicationData());
                    if (remote.getBatchMode() == BatchMode.ON) {
                        remote.flush();
                    }
                }
                catch (IOException e) {
                    LOG.connectionFailed(e);
                    throw new RuntimeIOException((Throwable)e);
                }
                finally {
                    ProxyWebSocketAdapter.this.remoteLock.unlock();
                }
            }
        };
    }

    private void cleanup() {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                ProxyWebSocketAdapter.this.closeQuietly();
            }
        });
    }

    private void closeQuietly() {
        try {
            if (this.backendSession != null && !this.backendSession.isOpen()) {
                this.backendSession.close();
            }
        }
        catch (IOException e) {
            LOG.connectionFailed(e);
        }
        if (this.container instanceof LifeCycle) {
            try {
                ((LifeCycle)this.container).stop();
            }
            catch (Exception e) {
                LOG.connectionFailed(e);
            }
        }
        if (this.frontendSession != null && !this.frontendSession.isOpen()) {
            this.frontendSession.close();
        }
    }

    private void flushBufferedMessages(RemoteEndpoint remote) throws IOException {
        LOG.debugLog("Flushing old buffered messages");
        for (String obj : this.messageBuffer) {
            LOG.debugLog("Sending old buffered message [From Backend <---]: " + obj);
            remote.sendString(obj);
        }
        this.messageBuffer.clear();
    }
}

