/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.websockets;

import java.net.HttpCookie;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.provider.federation.jwt.filter.SignatureVerificationCache;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.util.CertificateUtils;
import org.apache.knox.gateway.websockets.JWTValidator;
import org.apache.knox.gateway.websockets.WebSocketFilterConfig;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;

public class JWTValidatorFactory {
    private static final String KNOXSSO_COOKIE_NAME = "knoxsso.cookie.name";
    private static final String DEFAULT_SSO_COOKIE_NAME = "hadoop-jwt";
    private static final String JWT_EXPECTED_ISSUER = "jwt.expected.issuer";
    private static final String JWT_EXPECTED_SIGALG = "jwt.expected.sigalg";
    public static final String SSO_VERIFICATION_PEM = "sso.token.verification.pem";
    private static final JWTMessages jwtMessagesLog = (JWTMessages)MessagesFactory.get(JWTMessages.class);

    public static JWTValidator create(ServletUpgradeRequest req, GatewayServices gatewayServices, GatewayConfig gatewayConfig) {
        Map<String, String> params = JWTValidatorFactory.getParams(gatewayServices);
        String cookieName = params.containsKey(KNOXSSO_COOKIE_NAME) ? params.get(KNOXSSO_COOKIE_NAME) : DEFAULT_SSO_COOKIE_NAME;
        JWTValidator jwtValidator = new JWTValidator(JWTValidatorFactory.extractToken(req, cookieName), (JWTokenAuthority)gatewayServices.getService(ServiceType.TOKEN_SERVICE), SignatureVerificationCache.getInstance((String)"knoxsso", (FilterConfig)new WebSocketFilterConfig(params)));
        if (params.containsKey(SSO_VERIFICATION_PEM)) {
            try {
                RSAPublicKey publicKey = CertificateUtils.parseRSAPublicKey((String)params.get(SSO_VERIFICATION_PEM));
                jwtValidator.setPublicKey(publicKey);
            }
            catch (ServletException e) {
                throw new RuntimeException("Failed to obtain public key: " + (Object)((Object)e));
            }
        }
        if (params.containsKey(JWT_EXPECTED_ISSUER)) {
            jwtValidator.setExpectedIssuer(params.get(JWT_EXPECTED_ISSUER));
        }
        if (params.containsKey(JWT_EXPECTED_SIGALG)) {
            jwtValidator.setExpectedSigAlg(params.get(JWT_EXPECTED_SIGALG));
        }
        if (JWTValidatorFactory.isServerManagedTokenStateEnabled(gatewayConfig, params.get("knox.token.exp.server-managed"))) {
            jwtValidator.setTokenStateService((TokenStateService)gatewayServices.getService(ServiceType.TOKEN_STATE_SERVICE));
        }
        return jwtValidator;
    }

    private static Map<String, String> getParams(GatewayServices gatewayServices) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        TopologyService ts = (TopologyService)gatewayServices.getService(ServiceType.TOPOLOGY_SERVICE);
        for (Topology topology : ts.getTopologies()) {
            if (!topology.getName().equals("knoxsso")) continue;
            for (Service service : topology.getServices()) {
                if (!service.getRole().equals("KNOXSSO")) continue;
                return service.getParams();
            }
        }
        return params;
    }

    private static JWT extractToken(ServletUpgradeRequest req, String cookieName) {
        List ssoCookies = req.getCookies();
        if (ssoCookies != null) {
            for (HttpCookie ssoCookie : ssoCookies) {
                if (!cookieName.equals(ssoCookie.getName())) continue;
                try {
                    return new JWTToken(ssoCookie.getValue());
                }
                catch (ParseException parseException) {
                }
            }
        }
        jwtMessagesLog.missingBearerToken();
        throw new RuntimeException("No Valid JWT found");
    }

    private static boolean isServerManagedTokenStateEnabled(GatewayConfig gatewayConfig, String providerParamValue) {
        boolean isServerManaged = false;
        isServerManaged = providerParamValue == null || providerParamValue.isEmpty() ? gatewayConfig != null && gatewayConfig.isServerManagedTokenStateEnabled() : Boolean.parseBoolean(providerParamValue);
        return isServerManaged;
    }
}

