/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.HBasePeerState;
import com.cloudera.api.swagger.model.HBaseTableArgs;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Replication arguments for HBase service")
public class ApiHBaseReplicationArguments {
    @SerializedName(value="sourceHBaseService")
    private ApiServiceRef sourceHBaseService = null;
    @SerializedName(value="peerState")
    private HBasePeerState peerState = null;
    @SerializedName(value="hbaseClusterKey")
    private String hbaseClusterKey = null;
    @SerializedName(value="endPointClassName")
    private String endPointClassName = null;
    @SerializedName(value="tables")
    private List<HBaseTableArgs> tables = null;
    @SerializedName(value="replicationProperties")
    private Map<String, String> replicationProperties = null;
    @SerializedName(value="sourceAccount")
    private String sourceAccount = null;
    @SerializedName(value="sourceSchedulerPool")
    private String sourceSchedulerPool = null;
    @SerializedName(value="numMappers")
    private BigDecimal numMappers = null;
    @SerializedName(value="snapshotScratchLocation")
    private String snapshotScratchLocation = null;
    @SerializedName(value="validateReplicationSetup")
    private Boolean validateReplicationSetup = null;

    public ApiHBaseReplicationArguments sourceHBaseService(ApiServiceRef sourceHBaseService) {
        this.sourceHBaseService = sourceHBaseService;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiServiceRef getSourceHBaseService() {
        return this.sourceHBaseService;
    }

    public void setSourceHBaseService(ApiServiceRef sourceHBaseService) {
        this.sourceHBaseService = sourceHBaseService;
    }

    public ApiHBaseReplicationArguments peerState(HBasePeerState peerState) {
        this.peerState = peerState;
        return this;
    }

    @ApiModelProperty(value="")
    public HBasePeerState getPeerState() {
        return this.peerState;
    }

    public void setPeerState(HBasePeerState peerState) {
        this.peerState = peerState;
    }

    public ApiHBaseReplicationArguments hbaseClusterKey(String hbaseClusterKey) {
        this.hbaseClusterKey = hbaseClusterKey;
        return this;
    }

    @ApiModelProperty(value="")
    public String getHbaseClusterKey() {
        return this.hbaseClusterKey;
    }

    public void setHbaseClusterKey(String hbaseClusterKey) {
        this.hbaseClusterKey = hbaseClusterKey;
    }

    public ApiHBaseReplicationArguments endPointClassName(String endPointClassName) {
        this.endPointClassName = endPointClassName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEndPointClassName() {
        return this.endPointClassName;
    }

    public void setEndPointClassName(String endPointClassName) {
        this.endPointClassName = endPointClassName;
    }

    public ApiHBaseReplicationArguments tables(List<HBaseTableArgs> tables) {
        this.tables = tables;
        return this;
    }

    public ApiHBaseReplicationArguments addTablesItem(HBaseTableArgs tablesItem) {
        if (this.tables == null) {
            this.tables = new ArrayList<HBaseTableArgs>();
        }
        this.tables.add(tablesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<HBaseTableArgs> getTables() {
        return this.tables;
    }

    public void setTables(List<HBaseTableArgs> tables) {
        this.tables = tables;
    }

    public ApiHBaseReplicationArguments replicationProperties(Map<String, String> replicationProperties) {
        this.replicationProperties = replicationProperties;
        return this;
    }

    public ApiHBaseReplicationArguments putReplicationPropertiesItem(String key, String replicationPropertiesItem) {
        if (this.replicationProperties == null) {
            this.replicationProperties = new HashMap<String, String>();
        }
        this.replicationProperties.put(key, replicationPropertiesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, String> getReplicationProperties() {
        return this.replicationProperties;
    }

    public void setReplicationProperties(Map<String, String> replicationProperties) {
        this.replicationProperties = replicationProperties;
    }

    public ApiHBaseReplicationArguments sourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public ApiHBaseReplicationArguments sourceSchedulerPool(String sourceSchedulerPool) {
        this.sourceSchedulerPool = sourceSchedulerPool;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSourceSchedulerPool() {
        return this.sourceSchedulerPool;
    }

    public void setSourceSchedulerPool(String sourceSchedulerPool) {
        this.sourceSchedulerPool = sourceSchedulerPool;
    }

    public ApiHBaseReplicationArguments numMappers(BigDecimal numMappers) {
        this.numMappers = numMappers;
        return this;
    }

    @ApiModelProperty(value="")
    public BigDecimal getNumMappers() {
        return this.numMappers;
    }

    public void setNumMappers(BigDecimal numMappers) {
        this.numMappers = numMappers;
    }

    public ApiHBaseReplicationArguments snapshotScratchLocation(String snapshotScratchLocation) {
        this.snapshotScratchLocation = snapshotScratchLocation;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSnapshotScratchLocation() {
        return this.snapshotScratchLocation;
    }

    public void setSnapshotScratchLocation(String snapshotScratchLocation) {
        this.snapshotScratchLocation = snapshotScratchLocation;
    }

    public ApiHBaseReplicationArguments validateReplicationSetup(Boolean validateReplicationSetup) {
        this.validateReplicationSetup = validateReplicationSetup;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getValidateReplicationSetup() {
        return this.validateReplicationSetup;
    }

    public void setValidateReplicationSetup(Boolean validateReplicationSetup) {
        this.validateReplicationSetup = validateReplicationSetup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHBaseReplicationArguments apiHBaseReplicationArguments = (ApiHBaseReplicationArguments)o;
        return Objects.equals(this.sourceHBaseService, apiHBaseReplicationArguments.sourceHBaseService) && Objects.equals((Object)this.peerState, (Object)apiHBaseReplicationArguments.peerState) && Objects.equals(this.hbaseClusterKey, apiHBaseReplicationArguments.hbaseClusterKey) && Objects.equals(this.endPointClassName, apiHBaseReplicationArguments.endPointClassName) && Objects.equals(this.tables, apiHBaseReplicationArguments.tables) && Objects.equals(this.replicationProperties, apiHBaseReplicationArguments.replicationProperties) && Objects.equals(this.sourceAccount, apiHBaseReplicationArguments.sourceAccount) && Objects.equals(this.sourceSchedulerPool, apiHBaseReplicationArguments.sourceSchedulerPool) && Objects.equals(this.numMappers, apiHBaseReplicationArguments.numMappers) && Objects.equals(this.snapshotScratchLocation, apiHBaseReplicationArguments.snapshotScratchLocation) && Objects.equals(this.validateReplicationSetup, apiHBaseReplicationArguments.validateReplicationSetup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceHBaseService, this.peerState, this.hbaseClusterKey, this.endPointClassName, this.tables, this.replicationProperties, this.sourceAccount, this.sourceSchedulerPool, this.numMappers, this.snapshotScratchLocation, this.validateReplicationSetup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHBaseReplicationArguments {\n");
        sb.append("    sourceHBaseService: ").append(this.toIndentedString(this.sourceHBaseService)).append("\n");
        sb.append("    peerState: ").append(this.toIndentedString((Object)this.peerState)).append("\n");
        sb.append("    hbaseClusterKey: ").append(this.toIndentedString(this.hbaseClusterKey)).append("\n");
        sb.append("    endPointClassName: ").append(this.toIndentedString(this.endPointClassName)).append("\n");
        sb.append("    tables: ").append(this.toIndentedString(this.tables)).append("\n");
        sb.append("    replicationProperties: ").append(this.toIndentedString(this.replicationProperties)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    sourceSchedulerPool: ").append(this.toIndentedString(this.sourceSchedulerPool)).append("\n");
        sb.append("    numMappers: ").append(this.toIndentedString(this.numMappers)).append("\n");
        sb.append("    snapshotScratchLocation: ").append(this.toIndentedString(this.snapshotScratchLocation)).append("\n");
        sb.append("    validateReplicationSetup: ").append(this.toIndentedString(this.validateReplicationSetup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

