/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.DefaultMailboxes;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001B\u0006\r\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)a\u0006\u0001C\u0001_!9Q\b\u0001b\u0001\n\u0013q\u0004BB#\u0001A\u0003%q\bC\u0003G\u0001\u0011\u0005q\tC\u0003\\\u0001\u0011%A\fC\u0003e\u0001\u0011%Q\rC\u0003t\u0001\u0011%A\u000fC\u0004\u0002\n\u0001!I!a\u0003\u0003)5\u000b\u0017\u000e\u001c2pq\u0016\u001c\bK]8wSNLwN\\3s\u0015\tia\"\u0001\u0003iiR\u0004(BA\b\u0011\u0003\u0011QW.\u00199\u000b\u0005E\u0011\u0012!\u00026b[\u0016\u001c(BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\"\\1jY\n|\u00070T1oC\u001e,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#!\u00059Q.Y5mE>D\u0018B\u0001\u0013\"\u00059i\u0015-\u001b7c_bl\u0015M\\1hKJ\fQ\"\\3ue&\u001cg)Y2u_JL\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\r\t\u0007/\u001b\u0006\u0003WA\tq!\\3ue&\u001c7/\u0003\u0002.Q\tiQ*\u001a;sS\u000e4\u0015m\u0019;pef\fa\u0001P5oSRtDc\u0001\u00193gA\u0011\u0011\u0007A\u0007\u0002\u0019!)ad\u0001a\u0001?!)Qe\u0001a\u0001M!\u00121!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\na!\u001b8kK\u000e$(\"\u0001\u001e\u0002\u000b)\fg/\u0019=\n\u0005q:$AB%oU\u0016\u001cG/\u0001\u0004M\u001f\u001e;UIU\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tF\u0001\u0006g24GG[\u0005\u0003\t\u0006\u0013a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000bI\u0001\u0018GJ,\u0017\r^3NC&d'm\u001c=fg&3g*Z3eK\u0012$\"\u0001\u0013,\u0011\u0007%\u000b6+D\u0001K\u0015\tYE*A\u0005qk\nd\u0017n\u001d5fe*\u00111$\u0014\u0006\u0003\u001d>\u000bAaY8sK*\t\u0001+A\u0004sK\u0006\u001cGo\u001c:\n\u0005IS%!B*N_:|\u0007CA\rU\u0013\t)&D\u0001\u0003V]&$\b\"B,\u0007\u0001\u0004A\u0016aB:fgNLwN\u001c\t\u0003AeK!AW\u0011\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\u000612M]3bi\u0016$UMZ1vYRl\u0015-\u001b7c_b,7\u000f\u0006\u0002I;\")al\u0002a\u0001?\u0006AQo]3s]\u0006lW\r\u0005\u0002aE6\t\u0011M\u0003\u0002O!%\u00111-\u0019\u0002\t+N,'O\\1nK\u0006\u0011R.Y5mE>DHi\\3t]R,\u00050[:u)\r1'N\u001d\t\u0004\u0013F;\u0007CA\ri\u0013\tI'DA\u0004C_>dW-\u00198\t\u000b-D\u0001\u0019\u00017\u0002\u00175\f\u0017\u000e\u001c2pqB\u000bG\u000f\u001b\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u0006\nQ!\\8eK2L!!\u001d8\u0003\u00175\u000b\u0017\u000e\u001c2pqB\u000bG\u000f\u001b\u0005\u0006/\"\u0001\r\u0001W\u0001\u000ei>l\u0015-\u001b7c_b\u0004\u0016\r\u001e5\u0015\u0007U\f9\u0001\u0005\u0003\u001ambd\u0017BA<\u001b\u0005%1UO\\2uS>t\u0017\u0007E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005mTR\"\u0001?\u000b\u0005u4\u0012A\u0002\u001fs_>$h(\u0003\u0002\u00005\u00051\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a \u000e\t\u000b]K\u0001\u0019\u0001-\u0002\u001b\r\u0014X-\u0019;f\u001b\u0006LGNY8y)\u0015A\u0015QBA\b\u0011\u0015Y'\u00021\u0001m\u0011\u00159&\u00021\u0001Y\u0001")
public class MailboxesProvisioner {
    private final MailboxManager mailboxManager;
    private final MetricFactory metricFactory;
    private final Logger LOGGER;

    private Logger LOGGER() {
        return this.LOGGER;
    }

    public SMono<BoxedUnit> createMailboxesIfNeeded(MailboxSession session) {
        return SMono$.MODULE$.apply(this.metricFactory.decoratePublisherWithTimerMetric("JMAP-RFC-8621-mailboxes-provisioning", this.createDefaultMailboxes(session.getUser())));
    }

    private SMono<BoxedUnit> createDefaultMailboxes(Username username) {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(DefaultMailboxes.DEFAULT_MAILBOXES).asScala()).map(this.toMailboxPath(session));
        Function1 & Serializable x$1 = (Function1 & Serializable)mailboxPath -> this.mailboxDoesntExist((MailboxPath)mailboxPath, session);
        int x$2 = qual$1.filterWhen$default$2();
        SFlux qual$2 = qual$1.filterWhen((Function1)x$1, x$2);
        Function1 & Serializable x$3 = (Function1 & Serializable)mailboxPath -> this.createMailbox((MailboxPath)mailboxPath, session);
        int x$4 = qual$2.concatMap$default$2();
        return qual$2.concatMap((Function1)x$3, x$4).then();
    }

    private SMono<Object> mailboxDoesntExist(MailboxPath mailboxPath, MailboxSession session) {
        SMono sMono;
        try {
            sMono = SMono$.MODULE$.apply(this.mailboxManager.mailboxExists(mailboxPath, session)).map((Function1 & Serializable)exist -> BoxesRunTime.boxToBoolean((boolean)MailboxesProvisioner.$anonfun$mailboxDoesntExist$1(exist)));
        }
        catch (MailboxException exception) {
            sMono = SMono$.MODULE$.error((Throwable)exception);
        }
        return sMono;
    }

    private Function1<String, MailboxPath> toMailboxPath(MailboxSession session) {
        return (Function1 & Serializable)mailbox -> MailboxPath.forUser((Username)session.getUser(), (String)mailbox);
    }

    private SMono<BoxedUnit> createMailbox(MailboxPath mailboxPath, MailboxSession session) {
        return SMono$.MODULE$.apply(this.mailboxManager.createMailboxReactive(mailboxPath, MailboxManager.CreateOption.CREATE_SUBSCRIPTION, session)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof MailboxExistsException) {
                this.LOGGER().info("Mailbox {} have been created concurrently", (Object)mailboxPath);
                return SMono$.MODULE$.empty();
            }
            return SMono$.MODULE$.error(throwable);
        }).then();
    }

    public static final /* synthetic */ boolean $anonfun$mailboxDoesntExist$1(Boolean exist) {
        return !Predef$.MODULE$.Boolean2boolean(exist);
    }

    @Inject
    public MailboxesProvisioner(MailboxManager mailboxManager, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.metricFactory = metricFactory;
        this.LOGGER = LoggerFactory.getLogger(MailboxesProvisioner.class);
    }
}

