/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import androidx.annotation.RequiresApi;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.streamingaead.InputStreamDecrypter;
import com.google.crypto.tink.streamingaead.ReadableByteChannelDecrypter;
import com.google.crypto.tink.streamingaead.SeekableByteChannelDecrypter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;

final class StreamingAeadHelper
implements StreamingAead {
    PrimitiveSet<StreamingAead> primitives;

    public StreamingAeadHelper(PrimitiveSet<StreamingAead> primitives) throws GeneralSecurityException {
        if (primitives.getPrimary() == null) {
            throw new GeneralSecurityException("Missing primary primitive.");
        }
        this.primitives = primitives;
    }

    @Override
    public WritableByteChannel newEncryptingChannel(WritableByteChannel ciphertextDestination, byte[] associatedData) throws GeneralSecurityException, IOException {
        return this.primitives.getPrimary().getPrimitive().newEncryptingChannel(ciphertextDestination, associatedData);
    }

    @Override
    public ReadableByteChannel newDecryptingChannel(ReadableByteChannel ciphertextChannel, byte[] associatedData) throws GeneralSecurityException, IOException {
        return new ReadableByteChannelDecrypter(this.primitives, ciphertextChannel, associatedData);
    }

    @Override
    @RequiresApi(value=24)
    public SeekableByteChannel newSeekableDecryptingChannel(SeekableByteChannel ciphertextChannel, byte[] associatedData) throws GeneralSecurityException, IOException {
        return new SeekableByteChannelDecrypter(this.primitives, ciphertextChannel, associatedData);
    }

    @Override
    public InputStream newDecryptingStream(InputStream ciphertextStream, byte[] associatedData) throws GeneralSecurityException, IOException {
        return new InputStreamDecrypter(this.primitives, ciphertextStream, associatedData);
    }

    @Override
    public OutputStream newEncryptingStream(OutputStream ciphertext, byte[] associatedData) throws GeneralSecurityException, IOException {
        return this.primitives.getPrimary().getPrimitive().newEncryptingStream(ciphertext, associatedData);
    }
}

