/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.crypto.tink.jwt.JwtPublicKeyVerify;
import com.google.crypto.tink.jwt.JwtPublicKeyVerifyInternal;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;

class JwtPublicKeyVerifyWrapper
implements PrimitiveWrapper<JwtPublicKeyVerifyInternal, JwtPublicKeyVerify> {
    JwtPublicKeyVerifyWrapper() {
    }

    private static void validate(PrimitiveSet<JwtPublicKeyVerifyInternal> primitiveSet) throws GeneralSecurityException {
        for (List<PrimitiveSet.Entry<JwtPublicKeyVerifyInternal>> entries : primitiveSet.getAll()) {
            for (PrimitiveSet.Entry<JwtPublicKeyVerifyInternal> entry : entries) {
                if (entry.getOutputPrefixType() == OutputPrefixType.RAW || entry.getOutputPrefixType() == OutputPrefixType.TINK) continue;
                throw new GeneralSecurityException("unsupported OutputPrefixType");
            }
        }
    }

    @Override
    public JwtPublicKeyVerify wrap(PrimitiveSet<JwtPublicKeyVerifyInternal> primitives) throws GeneralSecurityException {
        JwtPublicKeyVerifyWrapper.validate(primitives);
        return new WrappedJwtPublicKeyVerify(primitives);
    }

    @Override
    public Class<JwtPublicKeyVerify> getPrimitiveClass() {
        return JwtPublicKeyVerify.class;
    }

    @Override
    public Class<JwtPublicKeyVerifyInternal> getInputPrimitiveClass() {
        return JwtPublicKeyVerifyInternal.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new JwtPublicKeyVerifyWrapper());
    }

    @Immutable
    private static class WrappedJwtPublicKeyVerify
    implements JwtPublicKeyVerify {
        private final PrimitiveSet<JwtPublicKeyVerifyInternal> primitives;

        public WrappedJwtPublicKeyVerify(PrimitiveSet<JwtPublicKeyVerifyInternal> primitives) {
            this.primitives = primitives;
        }

        @Override
        public VerifiedJwt verifyAndDecode(String compact, JwtValidator validator) throws GeneralSecurityException {
            GeneralSecurityException interestingException = null;
            for (List<PrimitiveSet.Entry<JwtPublicKeyVerifyInternal>> entries : this.primitives.getAll()) {
                for (PrimitiveSet.Entry<JwtPublicKeyVerifyInternal> entry : entries) {
                    try {
                        Optional<String> kid = JwtFormat.getKid(entry.getKeyId(), entry.getOutputPrefixType());
                        return entry.getPrimitive().verifyAndDecodeWithKid(compact, validator, kid);
                    }
                    catch (GeneralSecurityException e) {
                        if (!(e instanceof JwtInvalidException)) continue;
                        interestingException = e;
                    }
                }
            }
            if (interestingException != null) {
                throw interestingException;
            }
            throw new GeneralSecurityException("invalid JWT");
        }
    }
}

