/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.primitives.Booleans;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.model.mailbox.Mailbox;
import org.apache.james.jmap.draft.model.mailbox.MailboxNamespace;
import org.apache.james.jmap.draft.model.mailbox.Quotas;
import org.apache.james.jmap.draft.model.mailbox.Rights;
import org.apache.james.jmap.draft.model.mailbox.SortOrder;
import org.apache.james.jmap.draft.utils.quotas.DefaultQuotaLoader;
import org.apache.james.jmap.draft.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class MailboxFactory {
    private final MailboxManager mailboxManager;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public MailboxFactory(MailboxManager mailboxManager, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver) {
        this.mailboxManager = mailboxManager;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    public MailboxBuilder builder() {
        DefaultQuotaLoader defaultQuotaLoader = new DefaultQuotaLoader(this.quotaRootResolver, this.quotaManager);
        return new MailboxBuilder(this, defaultQuotaLoader);
    }

    private Mono<Mailbox> from(MailboxId mailboxId, MailboxPath mailboxPath, MailboxCounters.Sanitized mailboxCounters, MailboxACL resolvedAcl, Optional<Map<MailboxPath, MailboxMetaData>> userMailboxesMetadata, QuotaLoader quotaLoader, MailboxSession mailboxSession) {
        boolean isOwner = mailboxPath.belongsTo(mailboxSession);
        Optional<Role> role = Role.from((String)mailboxPath.getName()).filter(any -> mailboxPath.belongsTo(mailboxSession));
        Rights rights = Rights.fromACL(resolvedAcl).removeEntriesFor(mailboxPath.getUser());
        Username username = mailboxSession.getUser();
        return Mono.zip(quotaLoader.getQuotas(mailboxPath), this.getParentIdFromMailboxPath(mailboxPath, userMailboxesMetadata, mailboxSession)).map(tuple -> Mailbox.builder().id(mailboxId).name(this.getName(mailboxPath, mailboxSession)).parentId(((Optional)tuple.getT2()).orElse(null)).role(role).unreadMessages(mailboxCounters.getUnseen()).totalMessages(mailboxCounters.getCount()).sortOrder(SortOrder.getSortOrder(role)).sharedWith(rights).mayAddItems(rights.mayAddItems(username).orElse(isOwner)).mayCreateChild(rights.mayCreateChild(username).orElse(isOwner)).mayDelete(rights.mayDelete(username).orElse(isOwner)).mayReadItems(rights.mayReadItems(username).orElse(isOwner)).mayRemoveItems(rights.mayRemoveItems(username).orElse(isOwner)).mayRename(rights.mayRename(username).orElse(isOwner)).namespace(this.getNamespace(mailboxPath, isOwner)).quotas((Quotas)tuple.getT1()).build());
    }

    private MailboxNamespace getNamespace(MailboxPath mailboxPath, boolean isOwner) {
        if (isOwner) {
            return MailboxNamespace.personal();
        }
        return MailboxNamespace.delegated(mailboxPath.getUser());
    }

    @VisibleForTesting
    String getName(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        String name = mailboxPath.getName();
        if (name.contains(String.valueOf(mailboxSession.getPathDelimiter()))) {
            List levels = Splitter.on((char)mailboxSession.getPathDelimiter()).splitToList((CharSequence)name);
            return (String)levels.get(levels.size() - 1);
        }
        return name;
    }

    @VisibleForTesting
    Mono<Optional<MailboxId>> getParentIdFromMailboxPath(MailboxPath mailboxPath, Optional<Map<MailboxPath, MailboxMetaData>> userMailboxesMetadata, MailboxSession mailboxSession) {
        List levels = mailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter());
        if (levels.size() <= 1) {
            return Mono.just(Optional.empty());
        }
        MailboxPath parent = (MailboxPath)levels.get(levels.size() - 2);
        return userMailboxesMetadata.map(list -> Mono.just(this.retrieveParentFromMetadata(parent, (Map<MailboxPath, MailboxMetaData>)list))).orElseGet(Throwing.supplier(() -> this.retrieveParentFromBackend(mailboxSession, parent)).sneakyThrow());
    }

    private Mono<Optional<MailboxId>> retrieveParentFromBackend(MailboxSession mailboxSession, MailboxPath parent) {
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(parent, mailboxSession)).map(MessageManager::getId).map(Optional::of);
    }

    private Optional<MailboxId> retrieveParentFromMetadata(MailboxPath parent, Map<MailboxPath, MailboxMetaData> userMailboxesMetadata) {
        return Optional.ofNullable(userMailboxesMetadata.get(parent)).map(MailboxMetaData::getId);
    }

    public static class MailboxBuilder {
        private final MailboxFactory mailboxFactory;
        private QuotaLoader quotaLoader;
        private MailboxSession session;
        private Optional<MailboxId> id = Optional.empty();
        private Optional<MailboxMetaData> mailboxMetaData = Optional.empty();
        private Optional<Map<MailboxPath, MailboxMetaData>> userMailboxesMetadata = Optional.empty();

        private MailboxBuilder(MailboxFactory mailboxFactory, QuotaLoader quotaLoader) {
            this.mailboxFactory = mailboxFactory;
            this.quotaLoader = quotaLoader;
        }

        public MailboxBuilder id(MailboxId id) {
            this.id = Optional.of(id);
            return this;
        }

        public MailboxBuilder mailboxMetadata(MailboxMetaData mailboxMetaData) {
            this.mailboxMetaData = Optional.of(mailboxMetaData);
            return this;
        }

        public MailboxBuilder session(MailboxSession session) {
            this.session = session;
            return this;
        }

        public MailboxBuilder quotaLoader(QuotaLoader quotaLoader) {
            this.quotaLoader = quotaLoader;
            return this;
        }

        public MailboxBuilder usingPreloadedMailboxesMetadata(Optional<Map<MailboxPath, MailboxMetaData>> userMailboxesMetadata) {
            this.userMailboxesMetadata = userMailboxesMetadata;
            return this;
        }

        public Mono<Mailbox> build() {
            Preconditions.checkNotNull((Object)this.session);
            MailboxId mailboxId = this.computeMailboxId();
            Mono mailbox = this.mailboxMetaData.map(MailboxTuple::from).map(Mono::just).orElse(Mono.from((Publisher)this.mailboxFactory.mailboxManager.getMailboxReactive(mailboxId, this.session)).flatMap(messageManager -> MailboxTuple.from(messageManager, this.session)));
            return mailbox.flatMap(tuple -> this.mailboxFactory.from(mailboxId, tuple.mailboxPath, tuple.mailboxCounters, tuple.acl, this.userMailboxesMetadata, this.quotaLoader, this.session)).onErrorResume(MailboxNotFoundException.class, e -> Mono.empty());
        }

        private MailboxId computeMailboxId() {
            int idCount = Booleans.countTrue((boolean[])new boolean[]{this.id.isPresent(), this.mailboxMetaData.isPresent()});
            Preconditions.checkState((idCount == 1 ? 1 : 0) != 0, (Object)"You need exactly one 'id' 'mailboxMetaData'");
            return this.id.or(() -> this.mailboxMetaData.map(MailboxMetaData::getId)).get();
        }

        private Mono<MessageManager> mailbox(MailboxId mailboxId) {
            return Mono.from((Publisher)this.mailboxFactory.mailboxManager.getMailboxReactive(mailboxId, this.session));
        }

        private Mono<MessageManager> retrieveCachedMailbox(MailboxId mailboxId, Mono<MessageManager> mailbox) throws MailboxNotFoundException {
            return mailbox.onErrorResume(MailboxNotFoundException.class, any -> Mono.empty()).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException(mailboxId)));
        }
    }

    private static class MailboxTuple {
        private final MailboxPath mailboxPath;
        private final MailboxCounters.Sanitized mailboxCounters;
        private final MailboxACL acl;

        public static MailboxTuple from(MailboxMetaData metaData) {
            return new MailboxTuple(metaData.getPath(), metaData.getCounters().sanitize(), metaData.getResolvedAcls());
        }

        public static Mono<MailboxTuple> from(MessageManager messageManager, MailboxSession session) {
            return Mono.from((Publisher)messageManager.getMailboxCountersReactive(session)).map(MailboxCounters::sanitize).map((Function)Throwing.function(counters -> new MailboxTuple(messageManager.getMailboxPath(), (MailboxCounters.Sanitized)counters, messageManager.getResolvedAcl(session))));
        }

        private MailboxTuple(MailboxPath mailboxPath, MailboxCounters.Sanitized mailboxCounters, MailboxACL acl) {
            this.mailboxPath = mailboxPath;
            this.mailboxCounters = mailboxCounters;
            this.acl = acl;
        }
    }
}

