/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.search;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.backends.opensearch.AliasName;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.search.ScrolledSearch;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.opensearch.query.QueryConverter;
import org.apache.james.mailbox.opensearch.query.SortConverter;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import reactor.core.publisher.Flux;

public class OpenSearchSearcher {
    public static final int DEFAULT_SEARCH_SIZE = 100;
    private static final Time TIMEOUT = (Time)new Time.Builder().time("1m").build();
    private static final int MAX_ROUTING_KEY = 5;
    private final ReactorOpenSearchClient client;
    private final QueryConverter queryConverter;
    private final int size;
    private final AliasName aliasName;
    private final RoutingKey.Factory<MailboxId> routingKeyFactory;

    public OpenSearchSearcher(ReactorOpenSearchClient client, QueryConverter queryConverter, int size, ReadAliasName aliasName, RoutingKey.Factory<MailboxId> routingKeyFactory) {
        this.client = client;
        this.queryConverter = queryConverter;
        this.size = size;
        this.aliasName = aliasName;
        this.routingKeyFactory = routingKeyFactory;
    }

    public Flux<Hit<ObjectNode>> search(Collection<MailboxId> mailboxIds, SearchQuery query, Optional<Integer> limit, List<String> fields) {
        SearchRequest searchRequest = this.prepareSearch(mailboxIds, query, limit, fields);
        return new ScrolledSearch(this.client, searchRequest).searchHits();
    }

    private SearchRequest prepareSearch(Collection<MailboxId> mailboxIds, SearchQuery query, Optional<Integer> limit, List<String> fields) {
        List sorts = query.getSorts().stream().map(SortConverter::convertSort).map(fieldSort -> (SortOptions)new SortOptions.Builder().field(fieldSort).build()).collect(Collectors.toList());
        SearchRequest.Builder request = new SearchRequest.Builder().index(this.aliasName.getValue(), new String[0]).scroll(TIMEOUT).query(this.queryConverter.from(mailboxIds, query)).size(Integer.valueOf(this.computeRequiredSize(limit))).storedFields(fields).sort(sorts);
        return this.toRoutingKey(mailboxIds).map(arg_0 -> ((SearchRequest.Builder)request).routing(arg_0)).orElse(request).build();
    }

    private Optional<String> toRoutingKey(Collection<MailboxId> mailboxIds) {
        if (mailboxIds.size() < 5) {
            return Optional.of(mailboxIds.stream().map(arg_0 -> this.routingKeyFactory.from(arg_0)).map(RoutingKey::asString).collect(Collectors.joining(",")));
        }
        return Optional.empty();
    }

    private int computeRequiredSize(Optional<Integer> limit) {
        return limit.map(value -> Math.min(value, this.size)).orElse(this.size);
    }
}

