/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.cassandra.upload.UploadConfiguration;
import org.apache.james.jmap.cassandra.upload.UploadModule;
import org.apache.james.mailbox.model.ContentType;
import reactor.core.publisher.Mono;

public class UploadDAO {
    private final CassandraAsyncExecutor executor;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement insert;
    private final PreparedStatement selectOne;

    @Inject
    public UploadDAO(CqlSession session, BlobId.Factory blobIdFactory, UploadConfiguration configuration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.blobIdFactory = blobIdFactory;
        this.insert = session.prepare(QueryBuilder.insertInto((String)"uploads").value(UploadModule.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadModule.ID)).value(UploadModule.BUCKET_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadModule.BUCKET_ID)).value(UploadModule.BLOB_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadModule.BLOB_ID)).value(UploadModule.SIZE, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadModule.SIZE)).value(UploadModule.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadModule.USER)).value(UploadModule.CONTENT_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)UploadModule.CONTENT_TYPE)).usingTtl((int)configuration.getUploadTtlDuration().getSeconds()).build());
        this.selectOne = session.prepare(((Select)QueryBuilder.selectFrom((String)"uploads").all().whereColumn(UploadModule.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)UploadModule.ID))).build());
    }

    public Mono<Void> save(UploadRepresentation uploadRepresentation) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setUuid(UploadModule.ID, uploadRepresentation.getId().getId())).setString(UploadModule.BUCKET_ID, uploadRepresentation.getBucketName().asString())).setString(UploadModule.BLOB_ID, uploadRepresentation.getBlobId().asString())).setLong(UploadModule.SIZE, uploadRepresentation.getSize())).setString(UploadModule.USER, uploadRepresentation.getUser().asString())).setString(UploadModule.CONTENT_TYPE, uploadRepresentation.getContentType().asString()));
    }

    public Mono<UploadRepresentation> retrieve(UploadId id) {
        return this.executor.executeSingleRow((Statement)this.selectOne.bind(new Object[0]).setUuid(UploadModule.ID, id.getId())).map(row -> new UploadRepresentation(id, BucketName.of((String)row.getString(UploadModule.BUCKET_ID)), this.blobIdFactory.from(row.getString(UploadModule.BLOB_ID)), ContentType.of((String)row.getString(UploadModule.CONTENT_TYPE)), row.getLong(UploadModule.SIZE), Username.of((String)row.getString(UploadModule.USER))));
    }

    public static class UploadRepresentation {
        private final UploadId id;
        private final BucketName bucketName;
        private final BlobId blobId;
        private final ContentType contentType;
        private final long size;
        private final Username user;

        public UploadRepresentation(UploadId id, BucketName bucketName, BlobId blobId, ContentType contentType, long size, Username user) {
            this.user = user;
            Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Size must be strictly positive");
            this.id = id;
            this.bucketName = bucketName;
            this.blobId = blobId;
            this.contentType = contentType;
            this.size = size;
        }

        public UploadId getId() {
            return this.id;
        }

        public BucketName getBucketName() {
            return this.bucketName;
        }

        public BlobId getBlobId() {
            return this.blobId;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public long getSize() {
            return this.size;
        }

        public Username getUser() {
            return this.user;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UploadRepresentation) {
                UploadRepresentation other = (UploadRepresentation)obj;
                return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.bucketName, (Object)other.bucketName) && Objects.equal((Object)this.user, (Object)other.user) && Objects.equal((Object)this.blobId, (Object)other.blobId) && Objects.equal((Object)this.contentType, (Object)other.contentType) && Objects.equal((Object)this.size, (Object)other.size);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.bucketName, this.blobId, this.contentType, this.size, this.user});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("bucketName", (Object)this.bucketName).add("blobId", (Object)this.blobId).add("contentType", (Object)this.contentType).add("user", (Object)this.user).add("size", this.size).toString();
        }
    }
}

