/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.GhostMailbox;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxPathV3Table;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxPathV3DAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectUser;
    private final PreparedStatement selectAll;
    private final CqlSession session;
    private final DriverExecutionProfile lwtProfile;

    @Inject
    public CassandraMailboxPathV3DAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.session = session;
        this.insert = this.prepareInsert();
        this.delete = this.prepareDelete();
        this.select = this.prepareSelect();
        this.selectUser = this.prepareSelectUser();
        this.selectAll = this.prepareSelectAll();
        this.lwtProfile = JamesExecutionProfiles.getLWTProfile((CqlSession)session);
    }

    private PreparedStatement prepareDelete() {
        return this.session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"mailboxPathV3").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.NAMESPACE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.NAMESPACE)), (Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.USER)), (Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.MAILBOX_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.MAILBOX_NAME))})).ifExists()).build());
    }

    private PreparedStatement prepareInsert() {
        return this.session.prepare(QueryBuilder.insertInto((String)"mailboxPathV3").value(CassandraMailboxPathV3Table.NAMESPACE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.NAMESPACE)).value(CassandraMailboxPathV3Table.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.USER)).value(CassandraMailboxPathV3Table.MAILBOX_NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.MAILBOX_NAME)).value(CassandraMailboxPathV3Table.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.MAILBOX_ID)).value(CassandraMailboxPathV3Table.UIDVALIDITY, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.UIDVALIDITY)).ifNotExists().build());
    }

    private PreparedStatement prepareSelect() {
        return this.session.prepare(((Select)QueryBuilder.selectFrom((String)"mailboxPathV3").columns(new CqlIdentifier[]{CassandraMailboxPathV3Table.MAILBOX_ID, CassandraMailboxPathV3Table.UIDVALIDITY}).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.NAMESPACE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.NAMESPACE)), (Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.USER)), (Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.MAILBOX_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.MAILBOX_NAME))})).build());
    }

    private PreparedStatement prepareSelectUser() {
        return this.session.prepare(((Select)QueryBuilder.selectFrom((String)"mailboxPathV3").columns(new CqlIdentifier[]{CassandraMailboxPathV3Table.MAILBOX_ID, CassandraMailboxPathV3Table.UIDVALIDITY, CassandraMailboxPathV3Table.MAILBOX_NAME}).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.NAMESPACE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.NAMESPACE)), (Relation)Relation.column((CqlIdentifier)CassandraMailboxPathV3Table.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxPathV3Table.USER))})).build());
    }

    private PreparedStatement prepareSelectAll() {
        return this.session.prepare(QueryBuilder.selectFrom((String)"mailboxPathV3").columns(CassandraMailboxPathV3Table.FIELDS).build());
    }

    public Mono<Mailbox> retrieve(MailboxPath mailboxPath) {
        return this.retrieve(mailboxPath, JamesExecutionProfiles.ConsistencyChoice.STRONG);
    }

    public Mono<Mailbox> retrieve(MailboxPath mailboxPath, JamesExecutionProfiles.ConsistencyChoice consistencyChoice) {
        BoundStatement statement = (BoundStatement)((BoundStatement)((BoundStatement)this.select.bind(new Object[0]).set(CassandraMailboxPathV3Table.NAMESPACE, (Object)mailboxPath.getNamespace(), TypeCodecs.TEXT)).set(CassandraMailboxPathV3Table.USER, (Object)this.sanitizeUser(mailboxPath.getUser()), TypeCodecs.TEXT)).set(CassandraMailboxPathV3Table.MAILBOX_NAME, (Object)mailboxPath.getName(), TypeCodecs.TEXT);
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.setExecutionProfileIfNeeded(statement, consistencyChoice)).map(row -> this.fromRow((Row)row, mailboxPath.getUser(), mailboxPath.getNamespace(), mailboxPath.getName())).map((Function)FunctionalUtils.toFunction(this::logGhostMailboxSuccess)).switchIfEmpty(ReactorUtils.executeAndEmpty(() -> this.logGhostMailboxFailure(mailboxPath)));
    }

    public Flux<Mailbox> listUserMailboxes(String namespace, Username user, JamesExecutionProfiles.ConsistencyChoice consistencyChoice) {
        BoundStatementBuilder statementBuilder = (BoundStatementBuilder)((BoundStatementBuilder)this.selectUser.boundStatementBuilder(new Object[0]).set(CassandraMailboxPathV3Table.NAMESPACE, (Object)namespace, TypeCodecs.TEXT)).set(CassandraMailboxPathV3Table.USER, (Object)this.sanitizeUser(user), TypeCodecs.TEXT);
        if (consistencyChoice.equals((Object)JamesExecutionProfiles.ConsistencyChoice.STRONG)) {
            statementBuilder.setExecutionProfile(this.lwtProfile);
        }
        return this.cassandraAsyncExecutor.executeRows((Statement)statementBuilder.build()).map(row -> this.fromRow((Row)row, user, namespace)).map((Function)FunctionalUtils.toFunction(this::logReadSuccess));
    }

    public Flux<Mailbox> listAll() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAll.bind(new Object[0])).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logReadSuccess));
    }

    public void logGhostMailboxSuccess(Mailbox value) {
        this.logReadSuccess(value);
    }

    public void logGhostMailboxFailure(MailboxPath mailboxPath) {
        if (GhostMailbox.isDebugEnabled()) {
            GhostMailbox.logger().field("mailboxName", mailboxPath.asString()).field("type", "readMiss").log(logger -> logger.debug("Read mailbox missed"));
        }
    }

    private void logReadSuccess(Mailbox mailbox) {
        if (GhostMailbox.isDebugEnabled()) {
            GhostMailbox.logger().field("mailboxName", mailbox.generateAssociatedPath().asString()).field("type", "readSuccess").field("mailboxId", mailbox.getMailboxId().serialize()).log(logger -> logger.debug("Read mailbox succeeded"));
        }
    }

    private Mailbox fromRowToCassandraIdAndPath(Row row) {
        return this.fromRow(row, Username.of((String)((String)row.get(CassandraMailboxPathV3Table.USER, TypeCodecs.TEXT))), (String)row.get(CassandraMailboxPathV3Table.NAMESPACE, TypeCodecs.TEXT));
    }

    private Mailbox fromRow(Row row, Username username, String namespace) {
        return this.fromRow(row, username, namespace, (String)row.get(CassandraMailboxPathV3Table.MAILBOX_NAME, TypeCodecs.TEXT));
    }

    private Mailbox fromRow(Row row, Username username, String namespace, String name) {
        return new Mailbox(new MailboxPath(namespace, username, name), UidValidity.of((long)row.getLong(CassandraMailboxPathV3Table.UIDVALIDITY)), (MailboxId)CassandraId.of((UUID)row.get(CassandraMailboxPathV3Table.MAILBOX_ID, TypeCodecs.TIMEUUID)));
    }

    public Mono<Boolean> save(Mailbox mailbox) {
        CassandraId id = (CassandraId)mailbox.getMailboxId();
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setString(CassandraMailboxPathV3Table.NAMESPACE, mailbox.getNamespace())).setString(CassandraMailboxPathV3Table.USER, this.sanitizeUser(mailbox.getUser()))).setLong(CassandraMailboxPathV3Table.UIDVALIDITY, mailbox.getUidValidity().asLong())).setString(CassandraMailboxPathV3Table.MAILBOX_NAME, mailbox.getName())).setUuid(CassandraMailboxPathV3Table.MAILBOX_ID, id.asUuid()));
    }

    public Mono<Void> delete(MailboxPath mailboxPath) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.delete.bind(new Object[0]).setString(CassandraMailboxPathV3Table.NAMESPACE, mailboxPath.getNamespace())).setString(CassandraMailboxPathV3Table.USER, this.sanitizeUser(mailboxPath.getUser()))).setString(CassandraMailboxPathV3Table.MAILBOX_NAME, mailboxPath.getName()));
    }

    private String sanitizeUser(Username user) {
        if (user == null) {
            return "";
        }
        return user.asString();
    }

    private BoundStatement setExecutionProfileIfNeeded(BoundStatement statement, JamesExecutionProfiles.ConsistencyChoice consistencyChoice) {
        if (consistencyChoice.equals((Object)JamesExecutionProfiles.ConsistencyChoice.STRONG)) {
            return (BoundStatement)statement.setExecutionProfile(this.lwtProfile);
        }
        return statement;
    }
}

