/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraAnnotationTable;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAnnotationMapper
extends NonTransactionalMapper
implements AnnotationMapper {
    private final CassandraAsyncExecutor asyncExecutor;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement getStoredAnnotationsQuery;
    private final PreparedStatement countStoredAnnotationsQuery;
    private final PreparedStatement getStoredAnnotationsQueryForKeys;
    private final PreparedStatement getStoredAnnotationsQueryLikeKey;
    private final PreparedStatement getStoredAnnotationsQueryByKey;

    @Inject
    public CassandraAnnotationMapper(CqlSession session) {
        this.asyncExecutor = new CassandraAsyncExecutor(session);
        this.delete = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"annotation").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.KEY))})).build());
        this.insert = session.prepare(QueryBuilder.insertInto((String)"annotation").value(CassandraAnnotationTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.MAILBOX_ID)).value(CassandraAnnotationTable.KEY, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.KEY)).value(CassandraAnnotationTable.VALUE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.VALUE)).build());
        this.getStoredAnnotationsQuery = session.prepare(this.getStoredAnnotationsQuery().build());
        this.countStoredAnnotationsQuery = session.prepare(((Select)QueryBuilder.selectFrom((String)"annotation").countAll().where((Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.MAILBOX_ID)))).build());
        this.getStoredAnnotationsQueryForKeys = session.prepare(((Select)this.getStoredAnnotationsQuery().where((Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.KEY).in(QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.KEY)))).build());
        this.getStoredAnnotationsQueryLikeKey = session.prepare(((Select)this.getStoredAnnotationsQuery().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.KEY).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.GREATER_BIND_KEY)), (Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.KEY).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.LESSER_BIND_KEY))})).build());
        this.getStoredAnnotationsQueryByKey = session.prepare(((Select)this.getStoredAnnotationsQuery().where((Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.KEY)))).build());
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        return (List)this.getAllAnnotationsReactive(mailboxId).collectList().block();
    }

    public Flux<MailboxAnnotation> getAllAnnotationsReactive(MailboxId mailboxId) {
        return this.asyncExecutor.executeRows((Statement)this.getStoredAnnotationsQuery.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, ((CassandraId)mailboxId).asUuid())).map(this::toAnnotation);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.getAnnotationsByKeysReactive(mailboxId, keys).collectList().block();
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.asyncExecutor.executeRows((Statement)((BoundStatement)this.getStoredAnnotationsQueryForKeys.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, ((CassandraId)mailboxId).asUuid())).setList(CassandraAnnotationTable.KEY, (List)keys.stream().map(MailboxAnnotationKey::asString).collect(ImmutableList.toImmutableList()), String.class)).map(this::toAnnotation);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.getAnnotationsByKeysWithOneDepthReactive(mailboxId, keys).collectList().block();
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysWithOneDepthReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return Flux.fromIterable(keys).flatMap(annotation -> this.getAnnotationsByKeyWithOneDepth((CassandraId)mailboxId, (MailboxAnnotationKey)annotation));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.getAnnotationsByKeysWithAllDepthReactive(mailboxId, keys).collectList().block();
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysWithAllDepthReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return Flux.fromIterable(keys).flatMap(annotation -> this.getAnnotationsByKeyWithAllDepth((CassandraId)mailboxId, (MailboxAnnotationKey)annotation));
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        this.deleteAnnotationReactive(mailboxId, key).block();
    }

    public Mono<Void> deleteAnnotationReactive(MailboxId mailboxId, MailboxAnnotationKey key) {
        return this.asyncExecutor.executeVoid((Statement)((BoundStatement)this.delete.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, ((CassandraId)mailboxId).asUuid())).setString(CassandraAnnotationTable.KEY, key.asString()));
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        this.insertAnnotationReactive(mailboxId, mailboxAnnotation).block();
    }

    public Mono<Void> insertAnnotationReactive(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        Preconditions.checkArgument((!mailboxAnnotation.isNil() ? 1 : 0) != 0);
        return this.asyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, ((CassandraId)mailboxId).asUuid())).setString(CassandraAnnotationTable.KEY, mailboxAnnotation.getKey().asString())).setString(CassandraAnnotationTable.VALUE, (String)mailboxAnnotation.getValue().get()));
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return (Boolean)this.existReactive(mailboxId, mailboxAnnotation).block();
    }

    public Mono<Boolean> existReactive(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return this.asyncExecutor.executeReturnExists((Statement)((BoundStatement)this.getStoredAnnotationsQueryByKey.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, ((CassandraId)mailboxId).asUuid())).setString(CassandraAnnotationTable.KEY, mailboxAnnotation.getKey().asString()));
    }

    public int countAnnotations(MailboxId mailboxId) {
        return (Integer)this.countAnnotationsReactive(mailboxId).block();
    }

    public Mono<Integer> countAnnotationsReactive(MailboxId mailboxId) {
        return this.asyncExecutor.executeSingleRow((Statement)this.countStoredAnnotationsQuery.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, ((CassandraId)mailboxId).asUuid())).map(row -> Ints.checkedCast((long)row.getLong(0)));
    }

    private MailboxAnnotation toAnnotation(Row row) {
        return MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey(row.getString(CassandraAnnotationTable.KEY)), (String)row.getString(CassandraAnnotationTable.VALUE));
    }

    private Select getStoredAnnotationsQuery() {
        return (Select)QueryBuilder.selectFrom((String)"annotation").columns(CassandraAnnotationTable.SELECT_FIELDS).where((Relation)Relation.column((CqlIdentifier)CassandraAnnotationTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAnnotationTable.MAILBOX_ID)));
    }

    private String buildNextKey(String key) {
        return key + "/\u007f";
    }

    private Flux<MailboxAnnotation> getAnnotationsByKeyWithAllDepth(CassandraId mailboxId, MailboxAnnotationKey key) {
        return this.asyncExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.getStoredAnnotationsQueryLikeKey.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, mailboxId.asUuid())).setString(CassandraAnnotationTable.GREATER_BIND_KEY, key.asString())).setString(CassandraAnnotationTable.LESSER_BIND_KEY, this.buildNextKey(key.asString()))).map(this::toAnnotation).filter(annotation -> key.isAncestorOrIsEqual(annotation.getKey()));
    }

    private Flux<MailboxAnnotation> getAnnotationsByKeyWithOneDepth(CassandraId mailboxId, MailboxAnnotationKey key) {
        return this.asyncExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.getStoredAnnotationsQueryLikeKey.bind(new Object[0]).setUuid(CassandraAnnotationTable.MAILBOX_ID, mailboxId.asUuid())).setString(CassandraAnnotationTable.GREATER_BIND_KEY, key.asString())).setString(CassandraAnnotationTable.LESSER_BIND_KEY, this.buildNextKey(key.asString()))).map(this::toAnnotation).filter(annotation -> key.isParentOrIsEqual(annotation.getKey()));
    }
}

