/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraACLDAOV1;
import org.apache.james.mailbox.cassandra.mail.CassandraACLDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.ACLUpdated;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.AclV2DAOSubscriber;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.DeleteMailboxCommand;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.MailboxAggregateId;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.SetACLCommand;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.UpdateACLCommand;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.UserRightsDAOSubscriber;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraACLMapper
implements ACLMapper {
    public static final SchemaVersion ACL_V2_SCHEME_VERSION = new SchemaVersion(10);
    private final StoreV1 storeV1;
    private final StoreV2 storeV2;
    private final NaiveStore naiveStore;
    private final CassandraSchemaVersionManager versionManager;
    private final CassandraConfiguration cassandraConfiguration;

    @Inject
    public CassandraACLMapper(StoreV1 storeV1, StoreV2 storeV2, CassandraSchemaVersionManager versionManager, CassandraConfiguration cassandraConfiguration) {
        this.storeV1 = storeV1;
        this.storeV2 = storeV2;
        this.naiveStore = new NaiveStore();
        this.versionManager = versionManager;
        this.cassandraConfiguration = cassandraConfiguration;
    }

    private Mono<Store> store() {
        if (!this.cassandraConfiguration.isAclEnabled()) {
            return Mono.just((Object)this.naiveStore);
        }
        return this.versionManager.isBefore(ACL_V2_SCHEME_VERSION).map(isBefore -> {
            if (isBefore.booleanValue()) {
                return this.storeV1;
            }
            return this.storeV2;
        });
    }

    @Override
    public Mono<MailboxACL> getACL(CassandraId cassandraId) {
        return this.store().flatMap(store -> store.getACL(cassandraId));
    }

    @Override
    public Mono<ACLDiff> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
        return this.store().flatMap(store -> store.updateACL(cassandraId, command));
    }

    @Override
    public Mono<ACLDiff> setACL(CassandraId cassandraId, MailboxACL mailboxACL) {
        return this.store().flatMap(store -> store.setACL(cassandraId, mailboxACL));
    }

    @Override
    public Mono<Void> delete(CassandraId cassandraId) {
        return this.store().flatMap(store -> store.delete(cassandraId));
    }

    public static class NaiveStore
    implements Store {
        @Override
        public Mono<MailboxACL> getACL(CassandraId cassandraId) {
            return Mono.just((Object)MailboxACL.EMPTY);
        }

        @Override
        public Mono<ACLDiff> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
            return Mono.error((Throwable)new NotImplementedException());
        }

        @Override
        public Mono<ACLDiff> setACL(CassandraId cassandraId, MailboxACL mailboxACL) {
            return Mono.error((Throwable)new NotImplementedException());
        }

        @Override
        public Mono<Void> delete(CassandraId cassandraId) {
            return Mono.empty();
        }
    }

    public static class StoreV2
    implements Store {
        private final CassandraACLDAOV2 cassandraACLDAOV2;
        private final EventSourcingSystem eventSourcingSystem;

        @Inject
        public StoreV2(CassandraUserMailboxRightsDAO userMailboxRightsDAO, CassandraACLDAOV2 cassandraACLDAOV2, EventStore eventStore) {
            this.cassandraACLDAOV2 = cassandraACLDAOV2;
            ImmutableSet commandHandlers = ImmutableSet.of((Object)new DeleteMailboxCommand.CommandHandler(eventStore), (Object)new UpdateACLCommand.CommandHandler(eventStore), (Object)new SetACLCommand.CommandHandler(eventStore));
            ImmutableSet subscribers = ImmutableSet.of((Object)new UserRightsDAOSubscriber(userMailboxRightsDAO), (Object)new AclV2DAOSubscriber(cassandraACLDAOV2));
            this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)commandHandlers, (Set)subscribers, (EventStore)eventStore);
        }

        @Override
        public Mono<MailboxACL> getACL(CassandraId cassandraId) {
            return this.cassandraACLDAOV2.getACL(cassandraId);
        }

        @Override
        public Mono<ACLDiff> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
            return Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new UpdateACLCommand(new MailboxAggregateId(cassandraId), command))).flatMapIterable(events -> events).filter(ACLUpdated.class::isInstance).map(ACLUpdated.class::cast).map(ACLUpdated::getAclDiff).next().switchIfEmpty(Mono.error(() -> new MailboxException("Unable to update ACL")));
        }

        @Override
        public Mono<ACLDiff> setACL(CassandraId cassandraId, MailboxACL mailboxACL) {
            return Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new SetACLCommand(new MailboxAggregateId(cassandraId), mailboxACL))).flatMapIterable(events -> events).filter(ACLUpdated.class::isInstance).map(ACLUpdated.class::cast).map(ACLUpdated::getAclDiff).next().switchIfEmpty(Mono.error(() -> new MailboxException("Unable to set ACL")));
        }

        @Override
        public Mono<Void> delete(CassandraId cassandraId) {
            return Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new DeleteMailboxCommand(new MailboxAggregateId(cassandraId)))).then();
        }
    }

    public static class StoreV1
    implements Store {
        private final CassandraUserMailboxRightsDAO userMailboxRightsDAO;
        private final CassandraACLDAOV1 cassandraACLDAOV1;

        @Inject
        public StoreV1(CassandraUserMailboxRightsDAO userMailboxRightsDAO, CassandraACLDAOV1 cassandraACLDAOV1) {
            this.userMailboxRightsDAO = userMailboxRightsDAO;
            this.cassandraACLDAOV1 = cassandraACLDAOV1;
        }

        @Override
        public Mono<MailboxACL> getACL(CassandraId cassandraId) {
            return this.cassandraACLDAOV1.getACL(cassandraId);
        }

        @Override
        public Mono<ACLDiff> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
            return this.cassandraACLDAOV1.updateACL(cassandraId, command).flatMap(aclDiff -> this.userMailboxRightsDAO.update(cassandraId, (ACLDiff)aclDiff).thenReturn(aclDiff)).switchIfEmpty(Mono.error(() -> new MailboxException("Unable to update ACL")));
        }

        @Override
        public Mono<ACLDiff> setACL(CassandraId cassandraId, MailboxACL mailboxACL) {
            return this.cassandraACLDAOV1.setACL(cassandraId, mailboxACL).flatMap(aclDiff -> this.userMailboxRightsDAO.update(cassandraId, (ACLDiff)aclDiff).thenReturn(aclDiff)).switchIfEmpty(Mono.error(() -> new MailboxException("Unable to update ACL")));
        }

        @Override
        public Mono<Void> delete(CassandraId cassandraId) {
            return this.cassandraACLDAOV1.getACL(cassandraId).flatMap(acl -> this.userMailboxRightsDAO.update(cassandraId, ACLDiff.computeDiff((MailboxACL)acl, (MailboxACL)MailboxACL.EMPTY)).then(this.cassandraACLDAOV1.delete(cassandraId)));
        }
    }

    public static interface Store {
        public Mono<MailboxACL> getACL(CassandraId var1);

        public Mono<ACLDiff> updateACL(CassandraId var1, MailboxACL.ACLCommand var2);

        public Mono<ACLDiff> setACL(CassandraId var1, MailboxACL var2);

        public Mono<Void> delete(CassandraId var1);
    }
}

