/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.versions;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.backends.cassandra.versions.table.CassandraSchemaVersionTable;
import reactor.core.publisher.Mono;

public class CassandraSchemaVersionDAO {
    private final PreparedStatement readVersionStatement;
    private final PreparedStatement writeVersionStatement;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;

    @Inject
    public CassandraSchemaVersionDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readVersionStatement = this.prepareReadVersionStatement(session);
        this.writeVersionStatement = this.prepareWriteVersionStatement(session);
    }

    private PreparedStatement prepareReadVersionStatement(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"schemaversion").column(CassandraSchemaVersionTable.VALUE).build());
    }

    private PreparedStatement prepareWriteVersionStatement(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"schemaversion").value(CassandraSchemaVersionTable.KEY, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSchemaVersionTable.KEY)).value(CassandraSchemaVersionTable.VALUE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSchemaVersionTable.VALUE)).build());
    }

    public Mono<Optional<SchemaVersion>> getCurrentSchemaVersion() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.readVersionStatement.bind(new Object[0])).map(row -> row.getInt(CassandraSchemaVersionTable.VALUE)).reduce(Math::max).map(SchemaVersion::new).map(Optional::of).defaultIfEmpty(Optional.empty());
    }

    public Mono<Void> updateVersion(SchemaVersion newVersion) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.writeVersionStatement.bind(new Object[0]).setUuid(CassandraSchemaVersionTable.KEY, Uuids.timeBased())).setInt(CassandraSchemaVersionTable.VALUE, newVersion.getValue()));
    }

    @VisibleForTesting
    public Mono<Void> truncateVersion() {
        return this.cassandraAsyncExecutor.executeVoid((Statement)QueryBuilder.truncate((String)"schemaversion").build());
    }
}

