/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.mail.MailboxACL;
import org.apache.james.jmap.mail.Rfc4314Rights;
import org.apache.james.jmap.mail.Right;
import org.apache.james.jmap.mail.Rights;
import org.apache.james.mailbox.model.MailboxACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Rights$
implements Serializable {
    public static final Rights$ MODULE$ = new Rights$();
    private static final Logger LOGGER = LoggerFactory.getLogger(Rights.class);
    private static final Rights EMPTY = new Rights((Map<Username, Seq<Right>>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));

    private Logger LOGGER() {
        return LOGGER;
    }

    public Rights EMPTY() {
        return EMPTY;
    }

    public Rights of(Username username, Right right) {
        return this.of(username, (Seq<Right>)new .colon.colon((Object)right, (List)Nil$.MODULE$));
    }

    public Rights of(Username username, Seq<Right> rights) {
        Predef$.MODULE$.require(rights.nonEmpty(), (Function0 & Serializable)() -> "'rights' should not be empty");
        return new Rights((Map<Username, Seq<Right>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)username), rights)}))));
    }

    public Rights fromACL(MailboxACL acl) {
        return (Rights)((IterableOnceOps)((IterableOps)acl.entries().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Rights$.$anonfun$fromACL$1(x0$1)))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                MailboxACL.EntryKey entryKey = (MailboxACL.EntryKey)tuple2._1();
                Rfc4314Rights aclRights = (Rfc4314Rights)tuple2._2();
                return MODULE$.toRights(entryKey, aclRights);
            }
            throw new MatchError((Object)tuple2);
        })).fold((Object)this.EMPTY(), (Function2 & Serializable)(x$4, x$5) -> x$4.combine((Rights)x$5));
    }

    private Rights toRights(MailboxACL.EntryKey entryKey, Rfc4314Rights aclRights) {
        return this.of(Username.of((String)entryKey.getName()), aclRights.toRights());
    }

    private boolean isSupported(MailboxACL.EntryKey key) {
        MailboxACL.EntryKey entryKey = key;
        if (entryKey.isNegative()) {
            this.LOGGER().info("Negative keys are not supported");
            return false;
        }
        MailboxACL.EntryKey entryKey2 = org.apache.james.mailbox.model.MailboxACL.OWNER_KEY;
        MailboxACL.EntryKey entryKey3 = entryKey;
        if (!(entryKey2 != null ? !entryKey2.equals(entryKey3) : entryKey3 != null)) {
            return false;
        }
        if (entryKey.getNameType() != MailboxACL.NameType.user) {
            this.LOGGER().info("{} is not supported. Only 'user' is.", (Object)key.getNameType());
            return false;
        }
        return true;
    }

    public Rights apply(Map<Username, Seq<Right>> rights) {
        return new Rights(rights);
    }

    public Option<Map<Username, Seq<Right>>> unapply(Rights x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some(x$0.rights());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Rights$.class);
    }

    public static final /* synthetic */ boolean $anonfun$fromACL$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MailboxACL.EntryKey entryKey = (MailboxACL.EntryKey)tuple2._1();
            return MODULE$.isSupported(entryKey);
        }
        throw new MatchError((Object)tuple2);
    }

    private Rights$() {
    }
}

