/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.ConversionUtil;

public class ASTCaseWhen
extends SimpleNode {
    private boolean hasDefault;

    public ASTCaseWhen(boolean hasDefault, Expression ... nodes) {
        super(0);
        for (int i = 0; i < nodes.length; ++i) {
            this.jjtAddChild((Node)((Object)nodes[i]), i);
        }
        this.connectChildren();
        this.hasDefault = hasDefault;
    }

    public ASTCaseWhen(int id) {
        super(id);
    }

    @Override
    public Expression shallowCopy() {
        return new ASTCaseWhen(this.id);
    }

    @Override
    protected String getExpressionOperator(int index) {
        return "case";
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int numChildren = this.jjtGetNumChildren();
        if (numChildren == 0) {
            return null;
        }
        for (int i = 0; i < numChildren - 1; i += 2) {
            Object evaluatedWhen = this.evaluateChild(i, o);
            if (!ConversionUtil.toBoolean(evaluatedWhen)) continue;
            return this.evaluateChild(i + 1, o);
        }
        if (this.hasDefault) {
            return this.evaluateChild(numChildren - 1, o);
        }
        return null;
    }

    @Override
    public int getType() {
        return 57;
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        throw new UnsupportedOperationException("EJBQL 'case when' is not supported");
    }
}

