/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.CayenneMapEntry;

public class ASTDbIdPath
extends ASTDbPath {
    public static final String DBID_PREFIX = "dbid:";

    ASTDbIdPath(int id) {
        super(id);
    }

    public ASTDbIdPath() {
        super(63);
    }

    public ASTDbIdPath(String value) {
        super(63);
        this.setPath(value);
    }

    public ASTDbIdPath(CayennePath value) {
        super(63);
        this.setPath(value);
    }

    @Override
    public Expression shallowCopy() {
        ASTDbIdPath copy = new ASTDbIdPath(this.id);
        copy.path = this.path;
        return copy;
    }

    protected Object evaluateNode(Object o, CayennePath localPath) {
        CayennePath nextSegment;
        CayennePath objPath = localPath.parent();
        CayennePathSegment id = localPath.last();
        if (localPath.length() > 1) {
            if (o instanceof Persistent) {
                o = ((Persistent)o).readNestedProperty(objPath);
                nextSegment = CayennePath.of(List.of(id));
            } else {
                nextSegment = localPath;
            }
        } else {
            nextSegment = localPath;
        }
        if (o instanceof Persistent) {
            return this.toMap(o).get(id.value());
        }
        if (o instanceof Collection) {
            return ((Collection)o).stream().map(o1 -> this.evaluateNode(o1, nextSegment)).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    protected Object evaluateNode(Object o) {
        if (o instanceof Entity) {
            return this.evaluateEntityNode((Entity)o);
        }
        return this.evaluateNode(o, this.path);
    }

    @Override
    protected CayenneMapEntry evaluateEntityNode(Entity<?, ?, ?> entity) {
        DbAttribute pk;
        CayennePath objPath = this.path.parent();
        String id = this.path.last().value();
        if (!(entity instanceof ObjEntity)) {
            throw new CayenneRuntimeException("Unable to evaluate DBID path for DbEntity", new Object[0]);
        }
        ObjEntity objEntity = (ObjEntity)entity;
        if (objPath != null) {
            CayenneMapEntry entry = new ASTObjPath(objPath).evaluateEntityNode(objEntity);
            if (!(entry instanceof ObjRelationship)) {
                throw new CayenneRuntimeException("Unable to evaluate DBID path %s, relationship expected", this.path);
            }
            objEntity = ((ObjRelationship)entry).getTargetEntity();
        }
        if ((pk = (DbAttribute)objEntity.getDbEntity().getAttribute(id)) == null || !pk.isPrimaryKey()) {
            throw new CayenneRuntimeException("Unable to find PK %s for entity %s", id, objEntity.getName());
        }
        return pk;
    }

    @Override
    protected Map<?, ?> toMap(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        if (o instanceof ObjectId) {
            return ((ObjectId)o).getIdSnapshot();
        }
        if (o instanceof Persistent) {
            return ((Persistent)o).getObjectId().getIdSnapshot();
        }
        return null;
    }

    @Override
    public int getType() {
        return 52;
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        out.append("db:");
        out.append(rootId);
        out.append('.');
        out.append(this.path.value());
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append(DBID_PREFIX).append(this.path.value());
    }
}

