/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.procedure;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.ProcedureParameterBinding;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.NoopJdbcEventLogger;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.query.ProcedureQuery;

public class ProcedureTranslator {
    private static NotInParam OUT_PARAM = new NotInParam("[OUT]");
    protected ProcedureQuery query;
    protected Connection connection;
    protected DbAdapter adapter;
    protected EntityResolver entityResolver;
    protected List<ProcedureParameter> callParams;
    protected List<Object> values;
    protected JdbcEventLogger logger = NoopJdbcEventLogger.getInstance();

    public void setQuery(ProcedureQuery query) {
        this.query = query;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setAdapter(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public void setJdbcEventLogger(JdbcEventLogger logger) {
        this.logger = logger;
    }

    public JdbcEventLogger getJdbcEventLogger() {
        return this.logger;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected String createSqlString() {
        Procedure procedure = this.getProcedure();
        StringBuilder buf = new StringBuilder();
        int totalParams = this.callParams.size();
        if (procedure.isReturningValue()) {
            --totalParams;
            buf.append("{? = call ");
        } else {
            buf.append("{call ");
        }
        buf.append(procedure.getFullyQualifiedName());
        if (totalParams > 0) {
            buf.append("(?");
            for (int i = 1; i < totalParams; ++i) {
                buf.append(", ?");
            }
            buf.append(")");
        }
        buf.append("}");
        return buf.toString();
    }

    public PreparedStatement createStatement() throws Exception {
        this.callParams = this.getProcedure().getCallParameters();
        this.values = new ArrayList<Object>(this.callParams.size());
        this.initValues();
        String sqlStr = this.createSqlString();
        if (this.logger.isLoggable()) {
            ParameterBinding[] parameterBindings = new ParameterBinding[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                ProcedureParameter procedureParameter = this.callParams.get(i);
                Object value = this.values.get(i);
                if (value instanceof NotInParam) {
                    value = value.toString();
                }
                parameterBindings[i] = new ParameterBinding(value, procedureParameter.getType(), procedureParameter.getPrecision());
            }
            this.logger.logQuery(sqlStr, parameterBindings);
        }
        CallableStatement stmt = this.connection.prepareCall(sqlStr);
        this.initStatement(stmt);
        return stmt;
    }

    public Procedure getProcedure() {
        return this.query.getMetaData(this.entityResolver).getProcedure();
    }

    public ProcedureQuery getProcedureQuery() {
        return this.query;
    }

    protected void initStatement(CallableStatement stmt) throws Exception {
        if (this.values != null && this.values.size() > 0) {
            List<ProcedureParameter> params = this.getProcedure().getCallParameters();
            int len = this.values.size();
            for (int i = 0; i < len; ++i) {
                ProcedureParameter param = params.get(i);
                if (param.isOutParam()) {
                    this.setOutParam(stmt, param, i + 1);
                }
                if (!param.isInParameter()) continue;
                this.setInParam(stmt, param, this.values.get(i), i + 1);
            }
        }
    }

    protected void initValues() {
        Map<String, ?> queryValues = this.getProcedureQuery().getParameters();
        for (ProcedureParameter param : this.callParams) {
            if (param.getDirection() == 2) {
                this.values.add(OUT_PARAM);
                continue;
            }
            this.values.add(queryValues.get(param.getName()));
        }
    }

    protected void setInParam(CallableStatement stmt, ProcedureParameter param, Object val, int pos) throws Exception {
        ExtendedType extendedType = val != null ? this.adapter.getExtendedTypes().getRegisteredType(val.getClass()) : this.adapter.getExtendedTypes().getDefaultType();
        ProcedureParameterBinding binding = new ProcedureParameterBinding(param);
        binding.setStatementPosition(pos);
        binding.setValue(val);
        binding.setExtendedType(extendedType);
        this.adapter.bindParameter(stmt, binding);
    }

    protected void setOutParam(CallableStatement stmt, ProcedureParameter param, int pos) throws Exception {
        int precision = param.getPrecision();
        if (precision >= 0) {
            stmt.registerOutParameter(pos, param.getType(), precision);
        } else {
            stmt.registerOutParameter(pos, param.getType());
        }
    }

    static class NotInParam {
        protected String type;

        public NotInParam(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

