/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionConnectionDecorator;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionListener;

public abstract class BaseTransaction
implements Transaction {
    static final ThreadLocal<Transaction> CURRENT_TRANSACTION = new InheritableThreadLocal<Transaction>();
    protected static final int STATUS_ACTIVE = 1;
    protected static final int STATUS_COMMITTING = 2;
    protected static final int STATUS_COMMITTED = 3;
    protected static final int STATUS_ROLLEDBACK = 4;
    protected static final int STATUS_ROLLING_BACK = 5;
    protected static final int STATUS_NO_TRANSACTION = 6;
    protected static final int STATUS_MARKED_ROLLEDBACK = 7;
    protected Map<String, Connection> connections;
    protected Collection<TransactionListener> listeners;
    protected int status = 6;
    protected int defaultIsolationLevel = -1;
    protected TransactionDescriptor descriptor;

    static String decodeStatus(int status) {
        switch (status) {
            case 1: {
                return "STATUS_ACTIVE";
            }
            case 2: {
                return "STATUS_COMMITTING";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_ROLLING_BACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_MARKED_ROLLEDBACK";
            }
        }
        return "Unknown Status - " + status;
    }

    public static void bindThreadTransaction(Transaction transaction) {
        CURRENT_TRANSACTION.set(transaction);
    }

    public static Transaction getThreadTransaction() {
        return CURRENT_TRANSACTION.get();
    }

    protected BaseTransaction(TransactionDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void setRollbackOnly() {
        this.status = 7;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.status == 7;
    }

    @Override
    public void addListener(TransactionListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet<TransactionListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void begin() {
        if (this.status != 6) {
            throw new IllegalStateException("Transaction must have 'STATUS_NO_TRANSACTION' to begin. Current status: " + BaseTransaction.decodeStatus(this.status));
        }
        this.status = 1;
    }

    @Override
    public void commit() {
        if (this.status == 6) {
            return;
        }
        if (this.status != 1) {
            throw new IllegalStateException("Transaction must have 'STATUS_ACTIVE' to be committed. Current status: " + BaseTransaction.decodeStatus(this.status));
        }
        if (this.listeners != null) {
            for (TransactionListener listener : this.listeners) {
                listener.willCommit(this);
            }
        }
        this.processCommit();
        this.status = 3;
        this.close();
    }

    protected abstract void processCommit();

    @Override
    public void rollback() {
        try {
            if (this.status == 6 || this.status == 4 || this.status == 5) {
                return;
            }
            if (this.status != 1 && this.status != 7) {
                throw new IllegalStateException("Transaction must have 'STATUS_ACTIVE' or 'STATUS_MARKED_ROLLEDBACK' to be rolled back. Current status: " + BaseTransaction.decodeStatus(this.status));
            }
            if (this.listeners != null) {
                for (TransactionListener listener : this.listeners) {
                    listener.willRollback(this);
                }
            }
            this.processRollback();
            this.status = 4;
        }
        finally {
            this.close();
        }
    }

    protected abstract void processRollback();

    @Override
    public Map<String, Connection> getConnections() {
        return this.connections != null ? Collections.unmodifiableMap(this.connections) : Collections.emptyMap();
    }

    @Override
    public Connection getOrCreateConnection(String connectionName, DataSource dataSource) throws SQLException {
        Connection c = this.getExistingConnection(connectionName);
        if (c == null || c.isClosed()) {
            c = this.descriptor.getConnectionSupplier() != null ? this.descriptor.getConnectionSupplier().get() : dataSource.getConnection();
            this.addConnection(connectionName, c);
        }
        return new TransactionConnectionDecorator(c);
    }

    protected Connection getExistingConnection(String name) {
        return this.connections != null ? this.connections.get(name) : null;
    }

    protected Connection addConnection(String connectionName, Connection connection) {
        this.setIsolationLevelFrom(connection);
        TransactionConnectionDecorator wrapper = null;
        if (this.listeners != null) {
            for (TransactionListener listener : this.listeners) {
                connection = listener.decorateConnection(this, connection);
            }
            wrapper = new TransactionConnectionDecorator(connection);
            for (TransactionListener listener : this.listeners) {
                listener.willAddConnection(this, connectionName, wrapper);
            }
        }
        if (this.connections == null) {
            this.connections = new HashMap<String, Connection>();
        }
        if (wrapper == null) {
            wrapper = new TransactionConnectionDecorator(connection);
        }
        if (this.connections.put(connectionName, wrapper) != wrapper) {
            this.connectionAdded(connection);
        }
        return wrapper;
    }

    private void setIsolationLevelFrom(Connection connection) {
        if (this.descriptor.getIsolation() != -1) {
            try {
                this.defaultIsolationLevel = connection.getTransactionIsolation();
                connection.setTransactionIsolation(this.descriptor.getIsolation());
            }
            catch (SQLException ex) {
                throw new CayenneRuntimeException("Unable to set required isolation level: " + this.descriptor.getIsolation(), (Throwable)ex, new Object[0]);
            }
        }
    }

    protected void connectionAdded(Connection connection) {
        if (this.status == 6) {
            this.begin();
        }
        if (this.status != 1) {
            throw new IllegalStateException("Transaction must have 'STATUS_ACTIVE' to add a connection. Current status: " + BaseTransaction.decodeStatus(this.status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        for (Connection c : this.connections.values()) {
            try {
                c.unwrap(Connection.class).close();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                if (this.defaultIsolationLevel == -1) continue;
                try {
                    c.setTransactionIsolation(this.defaultIsolationLevel);
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

