/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.AggregateConditionNode;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.util.ConversionUtil;

public class ASTOr
extends AggregateConditionNode {
    private static final long serialVersionUID = 780157841581581297L;

    ASTOr(int id) {
        super(id);
    }

    public ASTOr() {
        super(1);
    }

    public ASTOr(Object[] nodes) {
        super(1);
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild((Node)nodes[i], i);
        }
        this.connectChildren();
    }

    public ASTOr(Collection<? extends Node> nodes) {
        super(1);
        int len = nodes.size();
        Iterator<? extends Node> it = nodes.iterator();
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(it.next(), i);
        }
        this.connectChildren();
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len == 0) {
            return Boolean.FALSE;
        }
        boolean unknown = false;
        boolean result = false;
        for (int i = 0; i < len; ++i) {
            Object value = this.evaluateChild(i, o);
            if (value == null) {
                unknown = true;
                continue;
            }
            if (!ConversionUtil.toBoolean(value)) continue;
            result = true;
            break;
        }
        return result ? Boolean.TRUE : (unknown ? null : Boolean.FALSE);
    }

    @Override
    public Expression shallowCopy() {
        return new ASTOr(this.id);
    }

    @Override
    protected String getExpressionOperator(int index) {
        return "or";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void jjtClose() {
        super.jjtClose();
        this.flattenTree();
    }
}

