/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.GenerateCodeAction;
import org.apache.cayenne.modeler.action.dbimport.ReverseEngineeringToolMenuAction;
import org.apache.cayenne.modeler.editor.DataDomainView;
import org.apache.cayenne.modeler.editor.cgen.domain.CgenTabController;
import org.apache.cayenne.modeler.editor.dbimport.domain.DbImportTabController;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.graph.DataDomainGraphTab;

public class DataDomainTabbedView
extends JTabbedPane
implements ChangeListener,
DomainDisplayListener {
    ProjectController mediator;
    DataDomainGraphTab graphTab;
    private JScrollPane cgenView;
    private CgenTabController cgenTabController;
    private JScrollPane dbImportView;
    private DbImportTabController dbImportTabController;

    public DataDomainTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.setTabPlacement(1);
        JScrollPane domainView = new JScrollPane(new DataDomainView(this.mediator));
        this.addTab("Main", domainView);
        this.addChangeListener(this);
        this.mediator.addDomainDisplayListener(this);
        this.dbImportTabController = new DbImportTabController(this.mediator);
        this.dbImportView = new JScrollPane(this.dbImportTabController.getView());
        this.addTab("Db Import", this.dbImportView);
        this.cgenTabController = new CgenTabController(this.mediator);
        this.cgenView = new JScrollPane(this.cgenTabController.getView());
        this.addTab("Class Generation", this.cgenView);
        this.graphTab = new DataDomainGraphTab(this.mediator);
        this.addTab("Graph", this.graphTab);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.getSelectedComponent() == this.graphTab) {
            this.graphTab.refresh();
        } else if (this.getSelectedComponent() == this.cgenView) {
            this.cgenTabController.getView().initView();
        } else if (this.getSelectedComponent() == this.dbImportView) {
            this.dbImportTabController.getView().initView();
        }
    }

    @Override
    public void currentDomainChanged(DomainDisplayEvent e) {
        if (e instanceof EntityDisplayEvent) {
            this.setSelectedComponent(this.graphTab);
        }
        if (this.getSelectedComponent() == this.cgenView) {
            this.fireStateChanged();
        }
        if (e.getSource() instanceof GenerateCodeAction) {
            this.setSelectedComponent(this.cgenView);
        }
        if (this.getSelectedComponent() == this.dbImportView) {
            this.fireStateChanged();
        }
        if (e.getSource() instanceof ReverseEngineeringToolMenuAction) {
            this.setSelectedComponent(this.dbImportView);
        }
    }
}

