/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.map.DbAttribute;

public class Values {
    protected final DbRowOp row;
    protected final boolean includeId;
    protected Map<String, Object> attributeSnapshot;
    protected Map<String, Object> fkSnapshot;
    protected List<DbAttribute> updatedAttributes;
    protected Map<String, ObjectId> flattenedIds;

    public Values(DbRowOp row, boolean includeId) {
        this.row = row;
        this.includeId = includeId;
    }

    public void addValue(DbAttribute attribute, Object value, boolean fk) {
        if (fk) {
            if (this.fkSnapshot == null) {
                this.fkSnapshot = new HashMap<String, Object>();
            }
            this.fkSnapshot.put(attribute.getName(), value);
        } else {
            if (this.attributeSnapshot == null) {
                this.attributeSnapshot = new HashMap<String, Object>();
            }
            this.attributeSnapshot.put(attribute.getName(), value);
        }
        if (this.updatedAttributes == null) {
            this.updatedAttributes = new ArrayList<DbAttribute>();
        }
        if (!this.updatedAttributes.contains(attribute)) {
            this.updatedAttributes.add(attribute);
        }
    }

    public void merge(Values other) {
        if (this.updatedAttributes == null || this.updatedAttributes.isEmpty()) {
            this.attributeSnapshot = other.attributeSnapshot;
            this.fkSnapshot = other.fkSnapshot;
            this.updatedAttributes = other.updatedAttributes;
        } else {
            if (other.attributeSnapshot != null) {
                if (this.attributeSnapshot == null) {
                    this.attributeSnapshot = new HashMap<String, Object>(other.attributeSnapshot.size());
                }
                other.attributeSnapshot.forEach(this.attributeSnapshot::putIfAbsent);
            }
            if (other.fkSnapshot != null) {
                if (this.fkSnapshot == null) {
                    this.fkSnapshot = new HashMap<String, Object>(other.fkSnapshot.size());
                }
                other.fkSnapshot.forEach(this.fkSnapshot::putIfAbsent);
            }
            if (other.updatedAttributes != null) {
                other.updatedAttributes.forEach(attr -> {
                    if (!this.updatedAttributes.contains(attr)) {
                        this.updatedAttributes.add((DbAttribute)attr);
                    }
                });
            }
        }
        if (other.flattenedIds != null) {
            if (this.flattenedIds == null) {
                this.flattenedIds = other.getFlattenedIds();
            } else {
                other.flattenedIds.forEach((path, id) -> this.flattenedIds.compute((String)path, (p, existing) -> {
                    if (id.getEntityName().equals(this.row.getChangeId().getEntityName()) || existing != null && existing.getEntityName().equals(this.row.getChangeId().getEntityName())) {
                        return this.row.getChangeId();
                    }
                    if (existing != null) {
                        return existing;
                    }
                    return id;
                }));
            }
        }
    }

    public void addFlattenedId(String path, ObjectId id) {
        if (this.flattenedIds == null) {
            this.flattenedIds = new HashMap<String, ObjectId>();
        }
        this.flattenedIds.put(path, id);
    }

    public Map<String, Object> getSnapshot() {
        if (!this.includeId) {
            return this.mergeSnapshots();
        }
        Map<String, Object> mergedSnapshot = this.mergeSnapshots();
        if (mergedSnapshot.isEmpty()) {
            return new HashMap<String, Object>(this.row.getChangeId().getIdSnapshot());
        }
        mergedSnapshot.putAll(this.row.getChangeId().getIdSnapshot());
        return mergedSnapshot;
    }

    private Map<String, Object> mergeSnapshots() {
        if (this.attributeSnapshot == null && this.fkSnapshot == null) {
            return Collections.emptyMap();
        }
        if (this.attributeSnapshot == null) {
            return this.fkSnapshot;
        }
        if (this.fkSnapshot == null) {
            return this.attributeSnapshot;
        }
        this.fkSnapshot.forEach(this.attributeSnapshot::put);
        return this.attributeSnapshot;
    }

    public List<DbAttribute> getUpdatedAttributes() {
        if (this.updatedAttributes == null) {
            return Collections.emptyList();
        }
        return this.updatedAttributes;
    }

    public Map<String, ObjectId> getFlattenedIds() {
        if (this.flattenedIds == null) {
            return Collections.emptyMap();
        }
        return this.flattenedIds;
    }

    public boolean isEmpty() {
        if (this.includeId) {
            return false;
        }
        return !(this.attributeSnapshot != null && !this.attributeSnapshot.isEmpty() || this.fkSnapshot != null && !this.fkSnapshot.isEmpty());
    }

    public void clear() {
        if (this.attributeSnapshot != null) {
            this.attributeSnapshot.clear();
        }
        if (this.fkSnapshot != null) {
            this.fkSnapshot.clear();
        }
        if (this.updatedAttributes != null) {
            this.updatedAttributes.clear();
        }
        if (this.flattenedIds != null) {
            this.flattenedIds.clear();
        }
    }

    public boolean isSameBatch(Values other) {
        if (this.updatedAttributes == null) {
            return other.updatedAttributes == null;
        }
        if (other.updatedAttributes == null) {
            return false;
        }
        return this.updatedAttributes.equals(other.updatedAttributes);
    }
}

