/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;

public abstract class SchemaContainer
extends FilterContainer {
    private final List<Schema> schemaCollection = new ArrayList<Schema>();

    public List<Schema> getSchemas() {
        return this.schemaCollection;
    }

    public void addSchema(Schema schema) {
        this.schemaCollection.add(schema);
    }

    public SchemaContainer() {
    }

    public SchemaContainer(SchemaContainer original) {
        super(original);
        for (Schema schema : original.getSchemas()) {
            this.addSchema(new Schema(schema));
        }
    }

    @Override
    public boolean isEmptyContainer() {
        if (!super.isEmptyContainer()) {
            return false;
        }
        if (this.schemaCollection.isEmpty()) {
            return true;
        }
        for (Schema schema : this.schemaCollection) {
            if (schema.isEmptyContainer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuilder toString(StringBuilder res, String prefix) {
        if (!SchemaContainer.isBlank(this.schemaCollection)) {
            for (Schema schema : this.schemaCollection) {
                schema.toString(res, prefix);
            }
        }
        return super.toString(res, prefix + "  ");
    }
}

