/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jcache;

import java.net.URI;
import java.net.URISyntaxException;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;

public class JCacheManagerProvider
implements Provider<CacheManager> {
    @Inject
    private RuntimeProperties properties;

    public CacheManager get() throws DIRuntimeException {
        CachingProvider provider;
        try {
            provider = Caching.getCachingProvider();
        }
        catch (CacheException e) {
            throw new RuntimeException("'cayenne-jcache' doesn't bundle any JCache providers. You must place a JCache 1.0 provider on classpath explicitly.", e);
        }
        URI jcacheConfig = this.getConfig();
        CacheManager manager = jcacheConfig == null ? provider.getCacheManager() : provider.getCacheManager(jcacheConfig, null);
        return manager;
    }

    private URI getConfig() {
        String config = this.properties.get("cayenne.jcache.provider_config");
        if (config == null) {
            return null;
        }
        try {
            return new URI(config);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Wrong value for JCache provider config property", ex);
        }
    }
}

