/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelSyncCallbackAction;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphDiffCompressor;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.remote.BootstrapMessage;
import org.apache.cayenne.remote.ClientConnection;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.QueryMessage;
import org.apache.cayenne.remote.SyncMessage;
import org.apache.cayenne.util.DeepMergeOperation;
import org.apache.cayenne.util.ToStringBuilder;

public class ClientChannel
implements DataChannel {
    protected ClientConnection connection;
    protected EventManager eventManager;
    protected EntityResolver entityResolver;
    protected boolean channelEventsEnabled;
    protected GraphDiffCompressor diffCompressor;
    EventBridge remoteChannelListener;

    public ClientChannel(ClientConnection connection, boolean channelEventsEnabled, EventManager eventManager, boolean remoteEventsOptional) throws CayenneRuntimeException {
        this.connection = connection;
        this.diffCompressor = new GraphDiffCompressor();
        this.eventManager = eventManager;
        boolean bl = this.channelEventsEnabled = eventManager != null && channelEventsEnabled;
        if (!remoteEventsOptional) {
            this.setupRemoteChannelListener();
        } else {
            try {
                this.setupRemoteChannelListener();
            }
            catch (CayenneRuntimeException cayenneRuntimeException) {
                // empty catch block
            }
        }
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public boolean isChannelEventsEnabled() {
        return this.channelEventsEnabled;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        EntityResolver resolver;
        QueryMetadata info;
        QueryResponse response = this.send((ClientMessage)new QueryMessage(query), QueryResponse.class);
        if (context != null && !(info = query.getMetaData(resolver = context.getEntityResolver())).isFetchingDataRows()) {
            response.reset();
            while (response.next()) {
                List objects;
                if (!response.isList() || (objects = response.currentList()).isEmpty()) continue;
                DeepMergeOperation merger = new DeepMergeOperation(context);
                List rsMapping = info.getResultSetMapping();
                if (rsMapping == null) {
                    this.convertSingleObjects(objects, merger);
                    continue;
                }
                if (rsMapping.size() == 1) {
                    if (!(rsMapping.get(0) instanceof EntityResultSegment)) continue;
                    this.convertSingleObjects(objects, merger);
                    continue;
                }
                this.processMixedResult(objects, merger, rsMapping);
            }
        }
        return response;
    }

    private void processMixedResult(List<Object[]> objects, DeepMergeOperation merger, List<Object> rsMapping) {
        int width = rsMapping.size();
        for (int i = 0; i < width; ++i) {
            if (!(rsMapping.get(i) instanceof EntityResultSegment)) continue;
            for (Object[] object : objects) {
                object[i] = this.convertObject(merger, (Persistent)object[i]);
            }
        }
    }

    private void convertSingleObjects(List<Object> objects, DeepMergeOperation merger) {
        ListIterator<Object> it = objects.listIterator();
        while (it.hasNext()) {
            Object next = it.next();
            it.set(this.convertObject(merger, (Persistent)next));
        }
    }

    private Object convertObject(DeepMergeOperation merger, Persistent object) {
        ObjectId id = object.getObjectId();
        if (id == null) {
            throw new CayenneRuntimeException("Server returned an object without an id: %s", new Object[]{object});
        }
        return merger.merge(object);
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        DataChannelSyncCallbackAction callbackAction = DataChannelSyncCallbackAction.getCallbackAction((LifecycleCallbackRegistry)this.getEntityResolver().getCallbackRegistry(), (GraphManager)originatingContext.getGraphManager(), (GraphDiff)changes, (int)syncType);
        callbackAction.applyPreCommit();
        changes = this.diffCompressor.compress(changes);
        GraphDiff replyDiff = this.send((ClientMessage)new SyncMessage(originatingContext, syncType, changes), GraphDiff.class);
        if (this.channelEventsEnabled) {
            EventSubject subject;
            switch (syncType) {
                case 3: {
                    subject = DataChannel.GRAPH_ROLLEDBACK_SUBJECT;
                    break;
                }
                case 1: {
                    subject = DataChannel.GRAPH_CHANGED_SUBJECT;
                    break;
                }
                case 2: {
                    subject = DataChannel.GRAPH_FLUSHED_SUBJECT;
                    break;
                }
                default: {
                    subject = null;
                }
            }
            if (subject != null) {
                boolean receivedNoop;
                boolean sentNoop = changes == null || changes.isNoop();
                boolean bl = receivedNoop = replyDiff == null || replyDiff.isNoop();
                if (!sentNoop || !receivedNoop) {
                    CompoundDiff notification = new CompoundDiff();
                    if (!sentNoop) {
                        notification.add(changes);
                    }
                    if (!receivedNoop) {
                        notification.add(replyDiff);
                    }
                    GraphEvent e = new GraphEvent((Object)this, (Object)originatingContext, (GraphDiff)notification);
                    this.eventManager.postEvent((EventObject)e, subject);
                }
            }
        }
        callbackAction.applyPostCommit();
        return replyDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            ClientChannel clientChannel = this;
            synchronized (clientChannel) {
                if (this.entityResolver == null) {
                    this.entityResolver = this.send((ClientMessage)new BootstrapMessage(), EntityResolver.class);
                }
            }
        }
        return this.entityResolver;
    }

    protected boolean setupRemoteChannelListener() throws CayenneRuntimeException {
        if (this.eventManager == null) {
            return false;
        }
        EventBridge bridge = this.connection.getServerEventBridge();
        if (bridge == null) {
            return false;
        }
        try {
            bridge.startup(this.eventManager, 3, null, (Object)this);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error starting EventBridge " + bridge, (Throwable)e, new Object[0]);
        }
        this.remoteChannelListener = bridge;
        return true;
    }

    protected <T> T send(ClientMessage message, Class<T> resultClass) {
        Object result = this.connection.sendMessage(message);
        if (result != null && !resultClass.isInstance(result)) {
            String resultString = new ToStringBuilder(result).toString();
            throw new CayenneRuntimeException("Expected result type: %s, actual: %s", new Object[]{resultClass.getName(), resultString});
        }
        return resultClass.cast(result);
    }
}

