/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.util.Util;

public class WebConfiguration {
    static final String CONFIGURATION_LOCATION_PARAMETER = "configuration-location";
    static final String EXTRA_MODULES_PARAMETER = "extra-modules";
    static final String DATA_DOMAIN_NAME_PARAMETER = "data-domain-name";
    private FilterConfig configuration;

    public WebConfiguration(final ServletConfig servletConfiguration) {
        this.configuration = new FilterConfig(){

            public ServletContext getServletContext() {
                return servletConfiguration.getServletContext();
            }

            public Enumeration getInitParameterNames() {
                return servletConfiguration.getInitParameterNames();
            }

            public String getInitParameter(String name) {
                return servletConfiguration.getInitParameter(name);
            }

            public String getFilterName() {
                return servletConfiguration.getServletName();
            }
        };
    }

    public WebConfiguration(FilterConfig filterConfiguration) {
        this.configuration = filterConfiguration;
    }

    public String getConfigurationLocation() {
        String configurationLocation = this.configuration.getInitParameter(CONFIGURATION_LOCATION_PARAMETER);
        if (configurationLocation != null) {
            return configurationLocation;
        }
        String name = this.configuration.getFilterName();
        if (name == null) {
            return null;
        }
        if (!name.endsWith(".xml")) {
            name = name + ".xml";
        }
        return name;
    }

    public String getDataDomainName() {
        return this.configuration.getInitParameter(DATA_DOMAIN_NAME_PARAMETER);
    }

    public Collection<Module> createModules(Module ... standardModules) throws ServletException {
        String extraModules;
        HashSet<String> existingModules = new HashSet<String>();
        ArrayList<Module> modules = new ArrayList<Module>();
        if (standardModules != null) {
            for (Module module : standardModules) {
                modules.add(module);
                existingModules.add(module.getClass().getName());
            }
        }
        if ((extraModules = this.configuration.getInitParameter(EXTRA_MODULES_PARAMETER)) != null) {
            StringTokenizer toks = new StringTokenizer(extraModules, ", \n\r");
            while (toks.hasMoreTokens()) {
                Module module;
                String moduleName = toks.nextToken();
                if (!existingModules.add(moduleName)) continue;
                try {
                    module = (Module)Util.getJavaClass((String)moduleName).newInstance();
                }
                catch (Exception e) {
                    String message = String.format("Error instantiating custom DI module '%s' by filter '%s': %s", moduleName, this.getClass().getName(), e.getMessage());
                    throw new ServletException(message, (Throwable)e);
                }
                modules.add(module);
            }
        }
        return modules;
    }

    public Map<String, String> getParameters() {
        Enumeration en = this.configuration.getInitParameterNames();
        if (!en.hasMoreElements()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            parameters.put(key, this.configuration.getInitParameter(key));
        }
        return parameters;
    }

    public Map<String, String> getOtherParameters() {
        Map<String, String> parameters = this.getParameters();
        if (!parameters.isEmpty()) {
            parameters.remove(CONFIGURATION_LOCATION_PARAMETER);
            parameters.remove(EXTRA_MODULES_PARAMETER);
        }
        return parameters;
    }
}

