/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.parser;

import java.lang.reflect.Method;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.template.Context;
import org.apache.cayenne.template.parser.ASTExpression;
import org.apache.cayenne.template.parser.IdentifierNode;

public class ASTMethod
extends IdentifierNode {
    public ASTMethod(int id) {
        super(id);
    }

    public Object evaluateAsObject(Context context, Object parentObject) {
        if (parentObject == null) {
            throw new IllegalStateException("To evaluate method node parent object should be set.");
        }
        try {
            return PropertyUtils.getProperty(parentObject, this.getIdentifier());
        }
        catch (IllegalArgumentException ex) {
            block6: for (Method m : parentObject.getClass().getMethods()) {
                if (!m.getName().equals(this.getIdentifier()) || m.getParameterTypes().length != this.jjtGetNumChildren()) continue;
                int i = 0;
                Object[] arguments = new Object[this.jjtGetNumChildren()];
                for (Class<Object> clazz : m.getParameterTypes()) {
                    ASTExpression child = (ASTExpression)this.jjtGetChild(i);
                    try {
                        if (clazz.isAssignableFrom(Object.class)) {
                            arguments[i] = child.evaluateAsObject(context);
                        } else if (clazz.isAssignableFrom(String.class)) {
                            arguments[i] = child.evaluateAsString(context);
                        } else if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
                            arguments[i] = child.evaluateAsBoolean(context);
                        } else if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
                            arguments[i] = child.evaluateAsDouble(context);
                        } else if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
                            arguments[i] = Float.valueOf((float)child.evaluateAsDouble(context));
                        } else if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
                            arguments[i] = child.evaluateAsLong(context);
                        } else if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
                            arguments[i] = (int)child.evaluateAsLong(context);
                        } else {
                            if (!clazz.isAssignableFrom(Object[].class)) continue block6;
                            arguments[i] = child.evaluateAsObject(context);
                        }
                    }
                    catch (UnsupportedOperationException ignored) {
                        continue block6;
                    }
                    ++i;
                }
                try {
                    return m.invoke(parentObject, arguments);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Unable to resolve method " + this.getIdentifier() + " with " + this.jjtGetNumChildren() + " args for object " + parentObject);
        }
    }

    @Override
    public void evaluate(Context context) {
        throw new UnsupportedOperationException("Unable evaluate method directly, must be solved via ASTVariable");
    }
}

