/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.directive;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.template.Context;
import org.apache.cayenne.template.directive.Directive;
import org.apache.cayenne.template.parser.ASTExpression;

public class BindObjectEqual
implements Directive {
    public static final BindObjectEqual INSTANCE = new BindObjectEqual();

    @Override
    public void apply(Context context, ASTExpression ... expressions) {
        Object object = expressions[0].evaluateAsObject(context);
        Map<String, Object> idMap = this.toIdMap(object);
        Object[] sqlColumns = null;
        Object[] idColumns = null;
        if (expressions.length > 1) {
            sqlColumns = expressions[1].evaluateAsObject(context);
        }
        if (expressions.length > 2) {
            idColumns = expressions[2].evaluateAsObject(context);
        }
        if (idMap == null) {
            if (sqlColumns == null || idColumns == null) {
                throw new CayenneRuntimeException("Invalid parameters. Either object has to be set or sqlColumns and idColumns or both.", new Object[0]);
            }
            idMap = Collections.emptyMap();
        } else if (sqlColumns == null || idColumns == null) {
            idColumns = sqlColumns = idMap.keySet().toArray();
        }
        String[] sqlColumnsArray = this.toArray(sqlColumns);
        String[] idColumnsArray = this.toArray(idColumns);
        if (sqlColumnsArray.length != idColumnsArray.length) {
            throw new CayenneRuntimeException("SQL columns and ID columns arrays have different sizes.", new Object[0]);
        }
        for (int i = 0; i < sqlColumnsArray.length; ++i) {
            Object value = idMap.get(idColumnsArray[i]);
            int jdbcType = value != null ? TypesMapping.getSqlTypeByJava(value.getClass()) : 4;
            this.renderColumn(context, sqlColumnsArray[i], i);
            this.render(context, new ParameterBinding(value, jdbcType, -1));
        }
    }

    protected void renderColumn(Context context, String columnName, int columnIndex) {
        if (columnIndex > 0) {
            context.getBuilder().append(" AND ");
        }
        context.getBuilder().append(columnName).append(' ');
    }

    protected void render(Context context, ParameterBinding binding) {
        if (binding.getValue() != null) {
            context.addParameterBinding(binding);
            context.getBuilder().append("= ?");
        } else {
            context.getBuilder().append("IS NULL");
        }
    }

    protected String[] toArray(Object columns) {
        if (columns instanceof Collection) {
            String[] columnsAsStrings = new String[((Collection)columns).size()];
            int idx = 0;
            for (Object column : (Collection)columns) {
                columnsAsStrings[idx++] = column.toString();
            }
            return columnsAsStrings;
        }
        if (columns.getClass().isArray()) {
            String[] columnsAsStrings = new String[((Object[])columns).length];
            int idx = 0;
            for (Object column : (Object[])columns) {
                columnsAsStrings[idx++] = column.toString();
            }
            return columnsAsStrings;
        }
        return new String[]{columns.toString()};
    }

    protected Map<String, Object> toIdMap(Object object) {
        if (object instanceof Persistent) {
            return ((Persistent)object).getObjectId().getIdSnapshot();
        }
        if (object instanceof ObjectId) {
            return ((ObjectId)object).getIdSnapshot();
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object != null) {
            throw new CayenneRuntimeException("Invalid object parameter, expected Persistent or ObjectId or null: " + object, new Object[0]);
        }
        return null;
    }
}

