/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SelectQueryMainTab;
import org.apache.cayenne.modeler.editor.SelectQueryOrderingTab;
import org.apache.cayenne.modeler.editor.SelectQueryPrefetchTab;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;

public class SelectQueryTabbedView
extends JTabbedPane {
    protected ProjectController mediator;
    protected SelectQueryMainTab mainTab;
    protected SelectQueryPrefetchTab prefetchTab;
    protected SelectQueryOrderingTab orderingTab;
    protected int lastSelectionIndex;

    public SelectQueryTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setTabPlacement(1);
        this.mainTab = new SelectQueryMainTab(this.mediator);
        this.addTab("General", new JScrollPane(this.mainTab));
        this.orderingTab = new SelectQueryOrderingTab(this.mediator);
        this.addTab("Orderings", this.orderingTab);
        this.prefetchTab = new SelectQueryPrefetchTab(this.mediator);
        this.addTab("Prefetches", this.prefetchTab);
    }

    private void initController() {
        this.mediator.addQueryDisplayListener(new QueryDisplayListener(){

            @Override
            public void currentQueryChanged(QueryDisplayEvent e) {
                SelectQueryTabbedView.this.initFromModel();
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectQueryTabbedView.this.lastSelectionIndex = SelectQueryTabbedView.this.getSelectedIndex();
                SelectQueryTabbedView.this.updateTabs();
            }
        });
    }

    void initFromModel() {
        if (!"SelectQuery".equals(this.mediator.getCurrentQuery().getType())) {
            this.setVisible(false);
            return;
        }
        if (this.mediator.getCurrentQuery().getRoot() == null) {
            this.lastSelectionIndex = 0;
        }
        if (this.getSelectedIndex() == this.lastSelectionIndex) {
            this.updateTabs();
        } else {
            this.setSelectedIndex(this.lastSelectionIndex);
        }
        this.setVisible(true);
    }

    void updateTabs() {
        switch (this.lastSelectionIndex) {
            case 0: {
                this.mainTab.initFromModel();
                break;
            }
            case 1: {
                this.orderingTab.initFromModel();
                break;
            }
            case 2: {
                this.prefetchTab.initFromModel();
            }
        }
    }
}

