/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ProjectUtil;

public class ProcedureParameterTableModel
extends CayenneTableModel<ProcedureParameter> {
    public static final int PARAMETER_NUMBER = 0;
    public static final int PARAMETER_NAME = 1;
    public static final int PARAMETER_DIRECTION = 2;
    public static final int PARAMETER_TYPE = 3;
    public static final int PARAMETER_LENGTH = 4;
    public static final int PARAMETER_PRECISION = 5;
    public static final String IN_PARAMETER = "IN";
    public static final String OUT_PARAMETER = "OUT";
    public static final String IN_OUT_PARAMETER = "INOUT";
    public static final String[] PARAMETER_DIRECTION_NAMES = new String[]{"", "IN", "OUT", "INOUT"};
    private static final int[] PARAMETER_INDEXES = new int[]{0, 1, 2, 3, 4, 5};
    private static final String[] PARAMETER_NAMES = new String[]{"No.", "Name", "Direction", "Type", "Max Length", "Precision"};
    protected Procedure procedure;

    public ProcedureParameterTableModel(Procedure procedure, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList<ProcedureParameter>(procedure.getCallParameters()));
        this.procedure = procedure;
    }

    public ProcedureParameter getParameter(int row) {
        return row >= 0 && row < this.objectList.size() ? (ProcedureParameter)this.objectList.get(row) : null;
    }

    @Override
    public void setUpdatedValueAt(Object newVal, int rowIndex, int columnIndex) {
        ProcedureParameter parameter = this.getParameter(rowIndex);
        if (parameter == null) {
            return;
        }
        String value = (String)newVal;
        ProcedureParameterEvent event = new ProcedureParameterEvent(this.eventSource, parameter);
        switch (columnIndex) {
            case 1: {
                event.setOldName(parameter.getName());
                this.setParameterName(value, parameter);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 2: {
                this.setParameterDirection(value, parameter);
                break;
            }
            case 3: {
                this.setParameterType(value, parameter);
                break;
            }
            case 4: {
                this.setMaxLength(value, parameter);
                break;
            }
            case 5: {
                this.setPrecision(value, parameter);
            }
        }
        this.mediator.fireProcedureParameterEvent(event);
    }

    protected void setPrecision(String newVal, ProcedureParameter parameter) {
        if (newVal == null || newVal.trim().length() <= 0) {
            parameter.setPrecision(-1);
        } else {
            try {
                parameter.setPrecision(Integer.parseInt(newVal));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mediator.getView(), "Invalid precision (" + newVal + "), only numbers are allowed.", "Invalid Precision Value", 0);
            }
        }
    }

    protected void setMaxLength(String newVal, ProcedureParameter parameter) {
        if (newVal == null || newVal.trim().length() <= 0) {
            parameter.setMaxLength(-1);
        } else {
            try {
                parameter.setMaxLength(Integer.parseInt(newVal));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mediator.getView(), "Invalid Max Length (" + newVal + "), only numbers are allowed", "Invalid Maximum Length", 0);
            }
        }
    }

    protected void setParameterType(String newVal, ProcedureParameter parameter) {
        parameter.setType(TypesMapping.getSqlTypeByName(newVal));
    }

    protected void setParameterDirection(String direction, ProcedureParameter parameter) {
        if (IN_PARAMETER.equals(direction)) {
            parameter.setDirection(1);
        } else if (OUT_PARAMETER.equals(direction)) {
            parameter.setDirection(2);
        } else if (IN_OUT_PARAMETER.equals(direction)) {
            parameter.setDirection(3);
        }
    }

    protected void setParameterName(String newVal, ProcedureParameter parameter) {
        ProjectUtil.setProcedureParameterName(parameter, newVal.trim());
    }

    @Override
    public Class getElementsClass() {
        return ProcedureParameter.class;
    }

    @Override
    public int getColumnCount() {
        return PARAMETER_INDEXES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ProcedureParameter parameter = this.getParameter(rowIndex);
        if (parameter == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return this.getParameterNumber(rowIndex, parameter);
            }
            case 1: {
                return this.getParameterName(parameter);
            }
            case 2: {
                return this.getParameterDirection(parameter);
            }
            case 3: {
                return this.getParameterType(parameter);
            }
            case 4: {
                return this.getParameterLength(parameter);
            }
            case 5: {
                return this.getParameterPrecision(parameter);
            }
        }
        return "";
    }

    protected String getParameterNumber(int rowIndex, ProcedureParameter parameter) {
        boolean hasReturnValue = parameter.getProcedure().isReturningValue();
        if (hasReturnValue) {
            return rowIndex == 0 ? "R" : "" + rowIndex;
        }
        return "" + (rowIndex + 1);
    }

    protected String getParameterPrecision(ProcedureParameter parameter) {
        return parameter.getPrecision() >= 0 ? String.valueOf(parameter.getPrecision()) : "";
    }

    protected String getParameterLength(ProcedureParameter parameter) {
        return parameter.getMaxLength() >= 0 ? String.valueOf(parameter.getMaxLength()) : "";
    }

    protected String getParameterType(ProcedureParameter parameter) {
        return TypesMapping.getSqlNameByType(parameter.getType());
    }

    protected String getParameterDirection(ProcedureParameter parameter) {
        int direction = parameter.getDirection();
        return PARAMETER_DIRECTION_NAMES[direction == -1 ? 0 : direction];
    }

    protected String getParameterName(ProcedureParameter parameter) {
        return parameter.getName();
    }

    @Override
    public String getColumnName(int col) {
        return PARAMETER_NAMES[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    public void orderList() {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return false;
    }

    @Override
    public void sortByColumn(int sortCol, boolean isAscent) {
    }
}

