/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.merge;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.dbsync.merge.context.MergeDirection;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.modeler.dialog.db.merge.MergerTokenSelectorController;

public class MergerTokenTableModel
extends AbstractTableModel {
    public static final int COL_SELECT = 0;
    public static final int COL_DIRECTION = 1;
    public static final int COL_NAME = 2;
    public static final int COL_VALUE = 3;
    private MergerTokenSelectorController controller;
    private List<MergerToken> tokens;

    public MergerTokenTableModel(MergerTokenSelectorController controller) {
        this.controller = controller;
        this.tokens = controller.getSelectableTokens();
    }

    private MergerTokenSelectorController getController() {
        return this.controller;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: 
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 2: {
                return "Operation";
            }
            case 1: {
                return "Direction";
            }
            case 3: {
                return "";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.tokens.size();
    }

    public MergerToken getToken(int rowIndex) {
        return this.tokens.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MergerToken token = this.getToken(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.getController().isSelected(token);
            }
            case 2: {
                return token.getTokenName();
            }
            case 1: {
                return token.getDirection();
            }
            case 3: {
                return token.getTokenValue();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        MergerToken token = this.getToken(rowIndex);
        switch (columnIndex) {
            case 0: {
                Boolean val = (Boolean)value;
                this.getController().select(token, val);
                break;
            }
            case 1: {
                MergeDirection direction = (MergeDirection)((Object)value);
                this.getController().setDirection(token, direction);
            }
        }
    }
}

