/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.DbJoinTableModel;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.undo.RelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.util.Util;

public class ResolveDbRelationshipDialog
extends CayenneDialog {
    protected DbRelationship relationship;
    protected DbRelationship reverseRelationship;
    protected JLabel sourceName;
    protected JLabel targetName;
    protected JTextField name;
    protected JTextField reverseName;
    protected CayenneTable table;
    protected TableColumnPreferences tablePreferences;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton saveButton;
    protected JButton cancelButton;
    private boolean cancelPressed;
    private RelationshipUndoableEdit undo;
    private boolean editable;

    public ResolveDbRelationshipDialog(DbRelationship relationship) {
        this(relationship, true);
    }

    public ResolveDbRelationshipDialog(DbRelationship relationship, boolean editable) {
        super(Application.getFrame(), "DbRelationship Inspector", true);
        this.editable = editable;
        if (!this.validateAndSetRelationship(relationship)) {
            this.cancelPressed = true;
            return;
        }
        this.initView();
        this.initController();
        this.initWithModel();
        this.undo = new RelationshipUndoableEdit(relationship);
        this.pack();
        this.centerWindow();
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.cancelPressed) {
            return;
        }
        super.setVisible(b);
    }

    private void initView() {
        this.sourceName = new JLabel();
        this.targetName = new JLabel();
        this.name = new JTextField(25);
        this.reverseName = new JTextField(25);
        this.addButton = new JButton("Add");
        this.addButton.setEnabled(this.editable);
        this.removeButton = new JButton("Remove");
        this.removeButton.setEnabled(this.editable);
        this.saveButton = new JButton("Done");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(this.editable);
        this.table = new AttributeTable();
        this.table.getSelectionModel().setSelectionMode(0);
        this.tablePreferences = new TableColumnPreferences(this.getClass(), "dbentity/dbjoinTable");
        this.getRootPane().setDefaultButton(this.saveButton);
        this.getContentPane().setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("right:max(50dlu;pref), 3dlu, fill:min(150dlu;pref), 3dlu, fill:min(50dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, top:14dlu, 3dlu, top:p:grow"));
        builder.setDefaultDialogBorder();
        builder.addSeparator("DbRelationship Information", cc.xywh(1, 1, 5, 1));
        builder.addLabel("Source Entity:", cc.xy(1, 3));
        builder.add((Component)this.sourceName, cc.xywh(3, 3, 1, 1));
        builder.addLabel("Target Entity:", cc.xy(1, 5));
        builder.add((Component)this.targetName, cc.xywh(3, 5, 1, 1));
        builder.addLabel("Relationship Name:", cc.xy(1, 7));
        builder.add((Component)this.name, cc.xywh(3, 7, 1, 1));
        builder.addLabel("Reverse Relationship Name:", cc.xy(1, 9));
        builder.add((Component)this.reverseName, cc.xywh(3, 9, 1, 1));
        builder.addSeparator("Joins", cc.xywh(1, 11, 5, 1));
        builder.add((Component)new JScrollPane(this.table), cc.xywh(1, 13, 3, 3, "fill, fill"));
        JPanel joinButtons = new JPanel(new FlowLayout(3));
        joinButtons.add(this.addButton);
        joinButtons.add(this.removeButton);
        builder.add((Component)joinButtons, cc.xywh(5, 13, 1, 3));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        JButton[] buttons = new JButton[]{this.cancelButton, this.saveButton};
        this.getContentPane().add((Component)PanelFactory.createButtonPanel(buttons), "South");
    }

    private boolean validateAndSetRelationship(DbRelationship relationship) {
        this.relationship = relationship;
        this.reverseRelationship = relationship.getReverseRelationship();
        if (relationship.getSourceEntity() == null) {
            throw new CayenneRuntimeException("Null source entity: %s", relationship);
        }
        if (relationship.getSourceEntity().getDataMap() == null) {
            throw new CayenneRuntimeException("Null DataMap: %s", relationship.getSourceEntity());
        }
        if (relationship.getTargetEntity() == null) {
            JOptionPane.showMessageDialog(this, "Please select target DbEntity first", "Select target", 1);
            return false;
        }
        return true;
    }

    private void initWithModel() {
        this.sourceName.setText(this.relationship.getSourceEntityName());
        this.targetName.setText(this.relationship.getTargetEntityName());
        this.name.setText(this.relationship.getName());
        if (this.reverseRelationship != null) {
            this.reverseName.setText(this.reverseRelationship.getName());
        }
        this.table.setModel(new DbJoinTableModel(this.relationship, this.getMediator(), this, true));
        TableColumn sourceColumn = this.table.getColumnModel().getColumn(0);
        JComboBox<String> comboBox = Application.getWidgetFactory().createComboBox(ModelerUtil.getDbAttributeNames(this.relationship.getSourceEntity()), true);
        AutoCompletion.enable(comboBox);
        sourceColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(comboBox));
        TableColumn targetColumn = this.table.getColumnModel().getColumn(1);
        comboBox = Application.getWidgetFactory().createComboBox(ModelerUtil.getDbAttributeNames(this.relationship.getTargetEntity()), true);
        AutoCompletion.enable(comboBox);
        targetColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(comboBox));
        this.tablePreferences.bind(this.table, null, null, null, 0, true);
    }

    private void initController() {
        this.addButton.addActionListener(e -> {
            DbJoinTableModel model = (DbJoinTableModel)this.table.getModel();
            DbJoin join = new DbJoin(this.relationship);
            model.addRow(join);
            this.undo.addDbJoinAddUndo(join);
            this.table.select(model.getRowCount() - 1);
        });
        this.removeButton.addActionListener(e -> {
            DbJoinTableModel model = (DbJoinTableModel)this.table.getModel();
            this.stopEditing();
            int row = this.table.getSelectedRow();
            DbJoin join = model.getJoin(row);
            this.undo.addDbJoinRemoveUndo(join);
            model.removeRow(join);
        });
        this.saveButton.addActionListener(e -> {
            this.cancelPressed = false;
            if (this.editable) {
                this.save();
            }
            this.dispose();
        });
        this.cancelButton.addActionListener(e -> {
            this.cancelPressed = true;
            this.setVisible(false);
        });
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void stopEditing() {
        int col_index = this.table.getEditingColumn();
        if (col_index >= 0) {
            TableColumn col = this.table.getColumnModel().getColumn(col_index);
            col.getCellEditor().stopCellEditing();
        }
    }

    private void save() {
        this.stopEditing();
        DbJoinTableModel model = (DbJoinTableModel)this.table.getModel();
        boolean updatingReverse = model.getObjectList().size() > 0;
        this.handleNameUpdate(this.relationship, this.name.getText().trim());
        model.commit();
        if (this.relationship.isToDependentPK() && !this.relationship.isValidForDepPk()) {
            this.relationship.setToDependentPK(false);
        }
        if (updatingReverse) {
            if (this.reverseRelationship == null) {
                this.reverseRelationship = new DbRelationship();
                this.reverseRelationship.setName(NameBuilder.builder(this.reverseRelationship, this.relationship.getTargetEntity()).baseName(this.reverseName.getText().trim()).name());
                this.reverseRelationship.setSourceEntity(this.relationship.getTargetEntity());
                this.reverseRelationship.setTargetEntityName(this.relationship.getSourceEntity());
                this.reverseRelationship.setToMany(!this.relationship.isToMany());
                this.relationship.getTargetEntity().addRelationship(this.reverseRelationship);
                if (this.relationship.getSourceEntity() == this.relationship.getTargetEntity()) {
                    this.getMediator().fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)this.reverseRelationship, (Entity)this.reverseRelationship.getSourceEntity(), 2));
                }
            } else {
                this.handleNameUpdate(this.reverseRelationship, this.reverseName.getText().trim());
            }
            Collection<DbJoin> reverseJoins = this.getReverseJoins();
            this.reverseRelationship.setJoins(reverseJoins);
            if (!this.relationship.isToDependentPK() && this.reverseRelationship.isValidForDepPk()) {
                this.reverseRelationship.setToDependentPK(true);
            }
        }
        Application.getInstance().getUndoManager().addEdit(this.undo);
        this.getMediator().fireDbRelationshipEvent(new RelationshipEvent((Object)this, this.relationship, this.relationship.getSourceEntity()));
    }

    private void handleNameUpdate(DbRelationship relationship, String userInputName) {
        if (Util.nullSafeEquals(relationship.getName(), userInputName)) {
            return;
        }
        String sourceEntityName = NameBuilder.builder(relationship, relationship.getSourceEntity()).baseName(userInputName).name();
        if (Util.nullSafeEquals(sourceEntityName, relationship.getName())) {
            return;
        }
        String oldName = relationship.getName();
        relationship.setName(sourceEntityName);
        this.undo.addNameUndo(relationship, oldName, sourceEntityName);
        this.getMediator().fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)relationship, (Entity)relationship.getSourceEntity(), oldName));
    }

    private Collection<DbJoin> getReverseJoins() {
        List<DbJoin> joins = this.relationship.getJoins();
        if (joins == null || joins.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DbJoin> reverseJoins = new ArrayList<DbJoin>(joins.size());
        for (DbJoin pair : joins) {
            DbJoin reverseJoin = pair.createReverseJoin();
            reverseJoin.setRelationship(this.reverseRelationship);
            reverseJoins.add(reverseJoin);
        }
        return reverseJoins;
    }

    final class AttributeTable
    extends CayenneTable {
        final Dimension preferredSize = new Dimension(203, 100);

        AttributeTable() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.preferredSize;
        }
    }
}

