/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.editor.dbimport.DraggableTreePanel;

public class DeleteNodeAction
extends TreeManipulationAction {
    private static final String ACTION_NAME = "Delete";
    private static final String ICON_NAME = "icon-trash.png";
    private DraggableTreePanel panel;

    public DeleteNodeAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    private void removePatternParams(FilterContainer container, Object selectedObject) {
        container.getExcludeTables().remove(selectedObject);
        container.getIncludeColumns().remove(selectedObject);
        container.getExcludeColumns().remove(selectedObject);
        container.getIncludeProcedures().remove(selectedObject);
        container.getExcludeProcedures().remove(selectedObject);
    }

    private void deleteChilds(Catalog catalog) {
        Object selectedObject = this.selectedElement.getUserObject();
        if (selectedObject instanceof Schema) {
            catalog.getSchemas().remove(selectedObject);
        } else if (selectedObject instanceof IncludeTable) {
            catalog.getIncludeTables().remove(selectedObject);
        } else if (selectedObject instanceof PatternParam) {
            this.removePatternParams(catalog, selectedObject);
        }
    }

    private void deleteChilds(Schema schema) {
        Object selectedObject = this.selectedElement.getUserObject();
        if (selectedObject instanceof IncludeTable) {
            schema.getIncludeTables().remove(selectedObject);
        } else if (selectedObject instanceof PatternParam) {
            this.removePatternParams(schema, selectedObject);
        }
    }

    private void deleteChilds(IncludeTable includeTable) {
        Object selectedObject = this.selectedElement.getUserObject();
        includeTable.getIncludeColumns().remove(selectedObject);
        includeTable.getExcludeColumns().remove(selectedObject);
    }

    private void deleteChilds(ReverseEngineering reverseEngineering) {
        Object selectedObject = this.selectedElement.getUserObject();
        if (selectedObject instanceof Catalog) {
            reverseEngineering.getCatalogs().remove(selectedObject);
        } else if (selectedObject instanceof Schema) {
            reverseEngineering.getSchemas().remove(selectedObject);
        } else if (selectedObject instanceof IncludeTable) {
            reverseEngineering.getIncludeTables().remove(selectedObject);
        } else if (selectedObject instanceof ExcludeTable) {
            reverseEngineering.getExcludeTables().remove(selectedObject);
        } else if (selectedObject instanceof IncludeColumn) {
            reverseEngineering.getIncludeColumns().remove(selectedObject);
        } else if (selectedObject instanceof ExcludeColumn) {
            reverseEngineering.getExcludeColumns().remove(selectedObject);
        } else if (selectedObject instanceof IncludeProcedure) {
            reverseEngineering.getIncludeProcedures().remove(selectedObject);
        } else if (selectedObject instanceof ExcludeProcedure) {
            reverseEngineering.getExcludeProcedures().remove(selectedObject);
        }
    }

    private void updateParentChilds() {
        DbImportModel model = (DbImportModel)this.tree.getModel();
        model.removeNodeFromParent(this.selectedElement);
        this.getProjectController().setDirty(true);
        model.reload(this.parentElement);
    }

    @Override
    public void performAction(ActionEvent e) {
        this.tree.stopEditing();
        TreePath[] paths = this.tree.getSelectionPaths();
        DbImportView rootParent = (DbImportView)this.panel.getParent().getParent();
        rootParent.getLoadDbSchemaButton().setEnabled(false);
        rootParent.getReverseEngineeringProgress().setVisible(true);
        if (paths != null) {
            ReverseEngineering reverseEngineeringOldCopy = new ReverseEngineering(this.tree.getReverseEngineering());
            rootParent.lockToolbarButtons();
            for (TreePath path : paths) {
                this.selectedElement = (DbImportTreeNode)path.getLastPathComponent();
                this.parentElement = (DbImportTreeNode)this.selectedElement.getParent();
                if (this.parentElement == null) continue;
                Object parentUserObject = this.parentElement.getUserObject();
                if (parentUserObject instanceof ReverseEngineering) {
                    ReverseEngineering reverseEngineering = (ReverseEngineering)parentUserObject;
                    this.deleteChilds(reverseEngineering);
                    continue;
                }
                if (parentUserObject instanceof Catalog) {
                    Catalog catalog = (Catalog)parentUserObject;
                    this.deleteChilds(catalog);
                    continue;
                }
                if (parentUserObject instanceof Schema) {
                    Schema schema = (Schema)parentUserObject;
                    this.deleteChilds(schema);
                    continue;
                }
                if (!(parentUserObject instanceof IncludeTable)) continue;
                IncludeTable includeTable = (IncludeTable)parentUserObject;
                this.deleteChilds(includeTable);
            }
            if (paths.length > 1) {
                this.getProjectController().setDirty(true);
                ArrayList<DbImportTreeNode> expandList = this.tree.getTreeExpandList();
                this.tree.translateReverseEngineeringToTree(this.tree.getReverseEngineering(), false);
                this.tree.expandTree(expandList);
            } else {
                this.updateParentChilds();
            }
            this.putReverseEngineeringToUndoManager(reverseEngineeringOldCopy);
            rootParent.getLoadDbSchemaButton().setEnabled(true);
            rootParent.getReverseEngineeringProgress().setVisible(false);
        }
    }

    public void setPanel(DraggableTreePanel panel) {
        this.panel = panel;
    }
}

