/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.io.File;
import javax.swing.KeyStroke;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.pref.RenamedPreferences;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;

public class SaveAction
extends SaveAsAction {
    public static String getActionName() {
        return "Save";
    }

    public SaveAction(Application application) {
        super(SaveAction.getActionName(), application);
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public String getIconName() {
        return "icon-save.png";
    }

    @Override
    protected boolean saveAll() throws Exception {
        Project p = this.getCurrentProject();
        if (p == null || p.getConfigurationResource() == null) {
            return super.saveAll();
        }
        String oldPath = p.getConfigurationResource().getURL().getPath();
        File oldProjectFile = new File(p.getConfigurationResource().getURL().toURI());
        this.getProjectController().getFileChangeTracker().pauseWatching();
        ProjectSaver saver = this.getApplication().getInjector().getInstance(ProjectSaver.class);
        saver.save(p);
        RenamedPreferences.removeOldPreferences();
        String[] path = oldPath.split("/");
        String[] newPath = p.getConfigurationResource().getURL().getPath().split("/");
        if (!path[path.length - 1].equals(newPath[newPath.length - 1])) {
            String newName = newPath[newPath.length - 1].replace(".xml", "");
            RenamedPreferences.copyPreferences(newName, this.getProjectController().getPreferenceForProject());
            RenamedPreferences.removeOldPreferences();
        }
        File newProjectFile = new File(p.getConfigurationResource().getURL().toURI());
        this.getApplication().getFrameController().changePathInLastProjListAction(oldProjectFile, newProjectFile);
        Application.getFrame().fireRecentFileListChanged();
        this.getProjectController().getFileChangeTracker().reconfigure();
        return true;
    }
}

