/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.undo.LinkDataMapUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class LinkDataMapAction
extends CayenneAction {
    public static String getActionName() {
        return "Link DataMap";
    }

    public LinkDataMapAction(Application application) {
        super(LinkDataMapAction.getActionName(), application);
    }

    public void linkDataMap(DataMap map, DataNodeDescriptor node) {
        if (map == null) {
            return;
        }
        if (node != null && node.getDataMapNames().contains(map.getName())) {
            return;
        }
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)mediator.getProject().getRootNode();
        ArrayList<DataNodeDescriptor> unlinkedNodes = new ArrayList<DataNodeDescriptor>();
        for (DataNodeDescriptor nextNode : dataChannelDescriptor.getNodeDescriptors()) {
            if (!nextNode.getDataMapNames().contains(map.getName())) continue;
            nextNode.getDataMapNames().remove(map.getName());
            mediator.fireDataNodeEvent(new DataNodeEvent((Object)this, nextNode));
            unlinkedNodes.add(nextNode);
        }
        if (node != null) {
            node.getDataMapNames().add(map.getName());
            mediator.fireDataNodeEvent(new DataNodeEvent((Object)this, node));
        }
        this.application.getUndoManager().addEdit(new LinkDataMapUndoableEdit(map, node, unlinkedNodes, mediator));
    }

    @Override
    public void performAction(ActionEvent e) {
    }
}

