/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.undo.CreateCallbackMethodUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.Util;

public class CreateCallbackMethodAction
extends CayenneAction {
    public static final String ACTION_NAME = "Create callback method";

    public CreateCallbackMethodAction(String actionName, Application application) {
        super(actionName, application);
    }

    public CreateCallbackMethodAction(Application application) {
        super(ACTION_NAME, application);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public CallbackMap getCallbackMap() {
        return this.getProjectController().getCurrentObjEntity().getCallbackMap();
    }

    @Override
    public String getIconName() {
        return "icon-create-method.png";
    }

    @Override
    public final void performAction(ActionEvent e) {
        CallbackType callbackType = this.getProjectController().getCurrentCallbackType();
        String methodName = NameBuilder.builderForCallbackMethod(this.getProjectController().getCurrentObjEntity()).baseName(this.toMethodName(callbackType.getType())).name();
        this.createCallbackMethod(callbackType, methodName);
        this.application.getUndoManager().addEdit(new CreateCallbackMethodUndoableEdit(callbackType, methodName));
    }

    public void createCallbackMethod(CallbackType callbackType, String methodName) {
        this.getCallbackMap().getCallbackDescriptor(callbackType.getType()).addCallbackMethod(methodName);
        CallbackMethodEvent ce = new CallbackMethodEvent(this, null, methodName, 2);
        this.getProjectController().fireCallbackMethodEvent(ce);
    }

    private String toMethodName(LifecycleEvent event) {
        return "on" + Util.underscoredToJava(event.name(), true);
    }
}

