/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.XMLEncoder;

public class SQLTemplateDescriptor
extends QueryDescriptor {
    protected String sql;
    protected Map<String, Integer> prefetchesMap = new HashMap<String, Integer>();
    protected Map<String, String> adapterSql = new HashMap<String, String>();

    public SQLTemplateDescriptor() {
        super("SQLTemplate");
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Map<String, String> getAdapterSql() {
        return this.adapterSql;
    }

    public void setAdapterSql(Map<String, String> adapterSql) {
        this.adapterSql = adapterSql;
    }

    public Map<String, Integer> getPrefetchesMap() {
        return this.prefetchesMap;
    }

    public void setPrefetchesMap(HashMap<String, Integer> prefetchesMap) {
        this.prefetchesMap = prefetchesMap;
    }

    public void addPrefetch(String prefetchPath, int semantics) {
        this.prefetchesMap.put(prefetchPath, semantics);
    }

    public void removePrefetch(String prefetchPath) {
        this.prefetchesMap.remove(prefetchPath);
    }

    @Override
    public SQLTemplate buildQuery() {
        SQLTemplate template = new SQLTemplate();
        if (this.root != null) {
            template.setRoot(this.root);
        }
        if (this.prefetchesMap != null) {
            for (Map.Entry<String, Integer> entry : this.prefetchesMap.entrySet()) {
                template.addPrefetch(PrefetchTreeNode.withPath(entry.getKey(), entry.getValue()));
            }
        }
        template.initWithProperties(this.getProperties());
        template.setDefaultTemplate(this.getSql());
        Map<String, String> adapterSql = this.getAdapterSql();
        if (adapterSql != null) {
            for (Map.Entry<String, String> entry : adapterSql.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                template.setTemplate(key, value);
            }
        }
        return template;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("query").attribute("name", this.getName()).attribute("type", this.type);
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        } else if (this.root instanceof DataMap) {
            rootType = "data-map";
            rootString = ((DataMap)this.root).getName();
        }
        if (rootType != null) {
            encoder.attribute("root", rootType).attribute("root-name", rootString);
        }
        this.encodeProperties(encoder);
        if (this.sql != null) {
            encoder.start("sql").cdata(this.sql, true).end();
        }
        if (this.adapterSql != null && !this.adapterSql.isEmpty()) {
            TreeSet<String> keys = new TreeSet<String>(this.adapterSql.keySet());
            for (String key : keys) {
                String sql;
                String value = this.adapterSql.get(key);
                if (key == null || value == null || (sql = value.trim()).length() <= 0) continue;
                encoder.start("sql").attribute("adapter-class", key).cdata(sql, true).end();
            }
        }
        PrefetchTreeNode prefetchTree = new PrefetchTreeNode();
        for (Map.Entry<String, Integer> entry : this.prefetchesMap.entrySet()) {
            PrefetchTreeNode node = prefetchTree.addPath(entry.getKey());
            node.setSemantics(entry.getValue());
            node.setPhantom(false);
        }
        encoder.nested(prefetchTree, delegate);
        delegate.visitQuery(this);
        encoder.end();
    }
}

