/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Collection;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ValueInjector;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.Evaluator;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTEqual
extends ConditionNode
implements ValueInjector {
    private static final long serialVersionUID = 1211234198602067833L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ASTEqual.class);

    ASTEqual(int id) {
        super(id);
    }

    public ASTEqual() {
        super(6);
    }

    public ASTEqual(SimpleNode path, Object value) {
        super(6);
        this.jjtAddChild(path, 0);
        this.jjtAddChild(new ASTScalar(value), 1);
        this.connectChildren();
    }

    @Override
    protected int getRequiredChildrenCount() {
        return 2;
    }

    @Override
    protected Boolean evaluateSubNode(Object o, Object[] evaluatedChildren) throws Exception {
        Object o2 = evaluatedChildren[1];
        return ASTEqual.evaluateImpl(o, o2) ? Boolean.TRUE : Boolean.FALSE;
    }

    static boolean evaluateImpl(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            if (o2 instanceof Collection) {
                for (Object element : (Collection)o2) {
                    if (element == null || !Evaluator.evaluator(element).eq(element, o1)) continue;
                    return true;
                }
                return false;
            }
            return Evaluator.evaluator(o1).eq(o1, o2);
        }
        return false;
    }

    @Override
    public Expression shallowCopy() {
        return new ASTEqual(this.id);
    }

    @Override
    protected String getExpressionOperator(int index) {
        return "=";
    }

    @Override
    protected String getEJBQLExpressionOperator(int index) {
        if (this.jjtGetChild(1) instanceof ASTScalar && ((ASTScalar)this.jjtGetChild(1)).getValue() == null) {
            return "is";
        }
        return this.getExpressionOperator(index);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void injectValue(Object o) {
        Node[] args = new Node[]{this.jjtGetChild(0), this.jjtGetChild(1)};
        int scalarIndex = -1;
        if (args[0] instanceof ASTScalar) {
            scalarIndex = 0;
        } else if (args[1] instanceof ASTScalar) {
            scalarIndex = 1;
        }
        if (scalarIndex != -1 && args[1 - scalarIndex] instanceof ASTObjPath) {
            ASTObjPath path = (ASTObjPath)args[1 - scalarIndex];
            try {
                path.injectValue(o, this.evaluateChild(scalarIndex, o));
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to inject value  on path " + path.getPath() + " to " + o, ex);
            }
        }
    }
}

